package factories

import (
	"a.yandex-team.ru/travel/app/backend/internal/references"
	proto "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CountryFactory struct {
	Value        *rasp.TCountry
	repoRegistry *references.Registry
}

func NewCountryFactory(repoRegistry *references.Registry) *CountryFactory {
	country := &rasp.TCountry{
		Id:    CountryIDCounter.Next(),
		GeoId: GeoIDCounter.Next(),
		Title: &proto.TTranslationCase{
			Ru: &proto.TTranslationCaseRu{},
			En: &proto.TTranslationCaseEn{},
		},
	}
	return &CountryFactory{
		Value:        country,
		repoRegistry: repoRegistry,
	}
}

func (f *CountryFactory) Create() *rasp.TCountry {
	CountryIDCounter.MarkUsed(f.Value.Id)
	GeoIDCounter.MarkUsed(f.Value.GeoId)
	f.repoRegistry.Countries.Add(f.Value)
	return f.Value
}
