package factories

import (
	"a.yandex-team.ru/travel/app/backend/internal/references"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RegionFactory struct {
	Value        *rasp.TRegion
	repoRegistry *references.Registry
}

func NewRegionFactory(repoRegistry *references.Registry) *RegionFactory {
	country := &rasp.TRegion{
		Id:    uint32(RegionIDCounter.Next()),
		GeoId: uint32(GeoIDCounter.Next()),
	}
	return &RegionFactory{
		Value:        country,
		repoRegistry: repoRegistry,
	}
}

func (f *RegionFactory) Create() *rasp.TRegion {
	RegionIDCounter.MarkUsed(int32(f.Value.Id))
	GeoIDCounter.MarkUsed(int32(f.Value.GeoId))
	f.repoRegistry.Regions.Add(f.Value)
	return f.Value
}
