package factories

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/app/backend/internal/references"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

func CreateDefaultRegistry(logger log.Logger) *references.Registry {
	registry := &references.Registry{
		Stations:    references.NewStationsRepository(),
		Settlements: references.NewSettlementsRepository(),
		Regions:     references.NewRegionRepository(),
		Countries:   references.NewCountryRepository(),
	}

	russia := NewCountryFactory(registry)
	russia.Value.Id = 225
	russia.Value.GeoId = 225
	russia.Value.TitleDefault = "Россия"
	russia.Value.Title.Ru.Nominative = "Россия"
	russia.Value.Title.En.Nominative = "Russia"
	russia.Create()

	turkey := NewCountryFactory(registry)
	turkey.Value.Id = 983
	turkey.Value.GeoId = 983
	turkey.Value.TitleDefault = "Турция"
	turkey.Value.Title.Ru.Nominative = "Турция"
	turkey.Value.Title.En.Nominative = "Turkey"
	turkey.Create()

	mow := NewSettlementFactory(registry)
	mow.Value.Id = 213
	mow.Value.GeoId = 213
	mow.Value.TitleDefault = "Москва"
	mow.Value.Title.Ru.Nominative = "Москва"
	mow.Value.Title.En.Nominative = "Moscow"
	mow.Value.Majority = rasp.TSettlement_MAJORITY_CAPITAL
	mow.Value.CountryId = russia.Value.Id
	mow.Create()

	spb := NewSettlementFactory(registry)
	spb.Value.Id = 2
	spb.Value.GeoId = 2
	spb.Value.TitleDefault = "Санкт-Петербург"
	spb.Value.Title.Ru.Nominative = "Санкт-Петербург"
	spb.Value.Title.En.Nominative = "Saint-Petersburg"
	spb.Value.Majority = rasp.TSettlement_MAJORITY_REGION_CAPITAL
	spb.Value.CountryId = russia.Value.Id
	spb.Create()

	ekb := NewSettlementFactory(registry)
	ekb.Value.Id = 54
	ekb.Value.GeoId = 54
	ekb.Value.TitleDefault = "Екатеринбург"
	ekb.Value.Title.Ru.Nominative = "Екатеринбург"
	ekb.Value.Title.En.Nominative = "Yekaterinburg"
	ekb.Value.Majority = rasp.TSettlement_MAJORITY_REGION_CAPITAL
	ekb.Value.CountryId = russia.Value.Id
	ekb.Create()

	kzn := NewSettlementFactory(registry)
	kzn.Value.Id = 43
	kzn.Value.GeoId = 43
	kzn.Value.TitleDefault = "Казань"
	kzn.Value.Title.Ru.Nominative = "Казань"
	kzn.Value.Title.En.Nominative = "Kazan"
	kzn.Value.Majority = rasp.TSettlement_MAJORITY_REGION_CAPITAL
	kzn.Value.CountryId = russia.Value.Id
	kzn.Create()

	ant := NewSettlementFactory(registry)
	ant.Value.Id = 11511
	ant.Value.GeoId = 11511
	ant.Value.TitleDefault = "Анталья"
	ant.Value.Title.Ru.Nominative = "Анталья"
	ant.Value.Title.En.Nominative = "Antalya"
	ant.Value.Majority = rasp.TSettlement_MAJORITY_REGION_CAPITAL
	ant.Value.CountryId = turkey.Value.Id
	ant.Create()

	ist := NewSettlementFactory(registry)
	ist.Value.Id = 11508
	ist.Value.GeoId = 11508
	ist.Value.TitleDefault = "Стамбул"
	ist.Value.Title.Ru.Nominative = "Стамбул"
	ist.Value.Title.En.Nominative = "Istanbul"
	ist.Value.Majority = rasp.TSettlement_MAJORITY_CAPITAL
	ist.Value.CountryId = turkey.Value.Id
	ist.Create()

	return registry
}
