package factories

import (
	"a.yandex-team.ru/travel/app/backend/internal/references"
	proto "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type SettlementFactory struct {
	Value        *rasp.TSettlement
	repoRegistry *references.Registry
}

func NewSettlementFactory(repoRegistry *references.Registry) *SettlementFactory {
	settlement := &rasp.TSettlement{
		Id:       SettlementIDCounter.Next(),
		GeoId:    GeoIDCounter.Next(),
		Majority: rasp.TSettlement_MAJORITY_COMMON_CITY,
		Title: &proto.TTranslationCase{
			Ru: &proto.TTranslationCaseRu{},
			En: &proto.TTranslationCaseEn{},
		},
	}
	return &SettlementFactory{
		Value:        settlement,
		repoRegistry: repoRegistry,
	}
}

func (f *SettlementFactory) Create() *rasp.TSettlement {
	SettlementIDCounter.MarkUsed(f.Value.Id)
	GeoIDCounter.MarkUsed(f.Value.GeoId)
	f.repoRegistry.Settlements.Add(f.Value)
	return f.Value
}
