package factories

import (
	"a.yandex-team.ru/travel/app/backend/internal/references"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationFactory struct {
	station      *rasp.TStation
	repoRegistry *references.Registry
}

func NewStationFactory(repoRegistry *references.Registry) *StationFactory {
	station := &rasp.TStation{
		Id:               StationIDCounter.Next(),
		TransportType:    rasp.TTransport_TYPE_TRAIN,
		Majority:         rasp.TStation_MAJORITY_MAIN_IN_CITY,
		IsSearchableFrom: true,
		IsSearchableTo:   false,
	}
	return &StationFactory{
		station:      station,
		repoRegistry: repoRegistry,
	}
}

func (f *StationFactory) Create() *rasp.TStation {
	if f.station.MajorityId == 0 {
		f.station.MajorityId = int32(f.station.Majority)
	}
	if f.station.SettlementId == 0 {
		settlement := NewSettlementFactory(f.repoRegistry).Create()
		f.station.SettlementId = settlement.Id
	}
	StationIDCounter.MarkUsed(f.station.Id)
	f.repoRegistry.Stations.Add(f.station)
	return f.station
}
