package references

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationsRepository struct {
	baseRepository *repository.StationRepository
}

func NewStationsRepository() *StationsRepository {
	return &StationsRepository{
		baseRepository: repository.NewStationRepository(),
	}
}

func (cr *StationsRepository) Write(b []byte) (int, error) {
	station := &rasp.TStation{}
	if err := proto.Unmarshal(b, station); err != nil {
		return 0, xerrors.Errorf("StationRepository:Write: %w", err)
	}
	cr.Add(station)
	return len(b), nil
}

func (cr *StationsRepository) Add(station *rasp.TStation) {
	cr.baseRepository.Add(station)
}

func (cr *StationsRepository) Get(id int) (*rasp.TStation, bool) {
	station, found := cr.baseRepository.Get(id)
	return station, found
}

func (cr *StationsRepository) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewStationsRepository()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*cr = *newState
	return nil
}
