package hashutils

import (
	"crypto/sha1"
	"encoding/hex"
	"encoding/json"
)

func GetSimpleHash(s string) (string, error) {
	h := sha1.New()
	_, err := h.Write([]byte(s))
	if err != nil {
		return "", err
	}
	hash := hex.EncodeToString(h.Sum(nil))
	return hash, nil
}

func GetSimpleHashFromStruct(s interface{}) (string, error) {
	bytes, err := json.Marshal(s)
	if err != nil {
		return "", err
	}
	h := sha1.New()
	_, err = h.Write(bytes)
	if err != nil {
		return "", err
	}
	hash := hex.EncodeToString(h.Sum(nil))
	return hash, nil
}
