#!/usr/bin/env bash
set -ex

cd $(dirname "${BASH_SOURCE[0]}")/..

# устанавливаем переменные окружения, необходимые для локального запуска
source ./tools/env.sh

# скачиваем данные-ресурсы, если их нет или они старше одного дня
mkdir -p dev
if [[ ! $(find "./dev/l10n.json" -mtime -1 -print) ]]; then
  echo "No actual L10N data, will load from sandbox"
  curl -H "Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/TRAVEL_APP_BACKEND_L10N_DATA > ./dev/l10n.json
fi
mkdir -p dev/common_dicts
if [[ ! $(find "./dev/common_dicts/TRAVEL_RASP_COMMON_DICTS_BUNDLE" -mtime -1 -print) ]]; then
  echo "No actual TRAVEL_RASP_COMMON_DICTS_BUNDLE, will load from sandbox"
  curl -H "Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/TRAVEL_RASP_COMMON_DICTS_BUNDLE -o ./dev/common_dicts/TRAVEL_RASP_COMMON_DICTS_BUNDLE
  tar -C ./dev/common_dicts -xvf ./dev/common_dicts/TRAVEL_RASP_COMMON_DICTS_BUNDLE
fi
# геобазу можно обновлять реже, например раз в месяц
if [[ $GEOBASE_MODE == "bin" ]] && [[ ! $(find "./dev/geodata.bin" -mtime -30 -print) ]]; then
  echo "No actual geodata.bin, will load from sandbox"
  curl -H "Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/GEODATA6BIN_STABLE -o ./dev/geodata.bin
fi
