#!/usr/bin/env bash
case $- in
    *x*) restore_x_setting() {
            set -x
         };;
      *) restore_x_setting() {
            set +x
         };;
esac
set +x

get_secret(){
   ya vault get version $1 --json | ya tool jq .value.$2 | tr -d '"'
}

# секрет нашего TVM приложения
# https://yav.yandex-team.ru/secret/sec-01fgkw03yxhz9t9fjvtvbkvvhs
export TRAVEL_APP_BACKEND_TVM_SECRET="$(get_secret sec-01fgkw03yxhz9t9fjvtvbkvvhs client_secret)"

# oauth-токен сендбокса для скачивания ресурсов
export SANDBOX_TOKEN="$(get_secret sec-01g1txpd5w70w1kshwhzk6syn4 token)"

# порт на котором будет поднят TVM демон
export LOCAL_TVM_PORT=9876

# URL на котором будет поднят TVM демон
export DEPLOY_TVM_TOOL_URL=http://localhost:${LOCAL_TVM_PORT}

# Адрес для нашего приложения, порт 8080 прописан в oauth TRAVELAPP-40 & OAUTHREG-459
export GRPCGATEWAY_ADDRESS="[::]:8080"

# путь до конфига нашего приложения в dev
export CONFIG_PATH=./cfg/config.development.yaml

# пароль для тестового redis
# https://yav.yandex-team.ru/secret/sec-01fvvqgwj8wpms31nsnczq9rqa
export REDIS_PASSWORD="$(get_secret sec-01fvvqgwj8wpms31nsnczq9rqa password)"

export LOGIN=`whoami`

restore_x_setting
