#!/bin/bash

set -e

#
# ИНФОРМАЦИЯ О НЕОБХОДИМЫХ ЗАВИСИМОСТЯХ
#
# protoc для linux
# ========================
#
# protoc берем поновее:
# https://github.com/protocolbuffers/protobuf/releases/tag/v3.19.4
#

# Получение корневой директории Аркадии. В большинстве случаев будет равняться "~/arcadia/"
arc_home=`arc root`
# Корневая директория протосхем
output_base_path="$arc_home/travel/app/backend/tools/proto-desc"
# Корневая директория протосхем в backend проекте
backend_api_path="$arc_home/travel/app/backend/api"
# Пути зависимостей протосхем
proto_dependencies_path="./:/$arc_home:$arc_home/contrib/libs/googleapis-common-protos:$arc_home/vendor/github.com/grpc-ecosystem/grpc-gateway"

mkdir -p $output_base_path

cd $backend_api_path

protoc --descriptor_set_out="$output_base_path/travel.proto.desc" --include_imports --proto_path="$proto_dependencies_path:$backend_api_path" $backend_api_path/**/**/*.proto

echo "Schemes updated: $output_base_path/travel.proto.desc"
