#!/bin/bash

set -e

#
#
# ИНФОРМАЦИЯ О НЕОБХОДИМЫХ ЗАВИСИМОСТЯХ
#
# protoc + swift для linux
# ========================
#
# protoc берем поновее:
# https://github.com/protocolbuffers/protobuf/releases/tag/v3.19.4
#
# swift берем тут:
# https://www.swift.org/download/
#
# swift-protobuf собираем по этой инструкции:
# https://github.com/apple/swift-protobuf
#
#

# Получение корневой директории Аркадии. В большинстве случаев будет равняться "~/arcadia/"
arc_home=`arc root`
# Корневая директория протосхем в iOS проекте
swift_base_path="$arc_home/mobile/travel/ios/Travel/Proto"
# Корневая директория протосхем в backend проекте
backend_api_path="$arc_home/travel/app/backend/api"
# Пути зависимостей протосхем. Нужны для генерации swift моделей
proto_dependencies_path="./:/$arc_home:$arc_home/contrib/libs/googleapis-common-protos:$arc_home/contrib/libs/protobuf/src:$arc_home/vendor/github.com/grpc-ecosystem/grpc-gateway"

cd $backend_api_path

# Проход по всем директориям протосхем
for dir in */ ; do
  # Путь для соответствующих протосхем в iOS проекте
  swift_path="$swift_base_path/$dir"
  # Создать директорию в iOS проекте, если такой директории не существует
  mkdir -p $swift_path
  cd "$backend_api_path/$dir/v1"
  
  for i in *.proto; do
    [ -f "$i" ] || break
    # Для каждого файла с расширением .proto вызывается команду генерации swift структуры
    protoc --swift_out=$swift_path --proto_path=$proto_dependencies_path $i
    # Вызов скрипта для добавления файла в структуру проекта
    echo `ruby $swift_base_path/add-file-to-xcodeproj.rb $swift_base_path ${dir%/} ${i%.*}`
  done
  
  echo "Schemes updated: $swift_path"
done

if [ "$1" == "--add" ]; then
  `arc add $swift_base_path/../../`
fi
