#!/usr/bin/env bash
set -ex

cd $(dirname "${BASH_SOURCE[0]}")/..

# собираем
ya make

# устанавливаем переменные окружения, необходимые для локального запуска
source ./tools/env.sh

# переменные окружения для дебага
export GEOBASE_MODE=stub
export CGO_ENABLED=0
export DEPLOY_TVM_TOOL_URL=http://localhost:9876

# запускаем TVM
source ./tools/run-tvm.sh

# скачиваем данные-ресурсы, если их нет или они старше одного дня
source ./tools/download-resources.sh

## Логи как в error booster
## Нужно запустить отдельно while true; do { echo -e 'HTTP/1.1 200 OK\r\n'; } | nc -l 12345; done
## и раскоментить строчки ниже
# export ERROR_BOOSTER_HTTP_PORT=localhost
# export ERROR_BOOSTER_HTTP_HOST=12345

# и запускаем приложение
go build -gcflags="all=-N -l" ./cmd/api/main.go
./cmd/api/api
