#!/usr/bin/env bash
set -ex

cd $(dirname "${BASH_SOURCE[0]}")/..

# собираем
ya make

# устанавливаем переменные окружения, необходимые для локального запуска
source ./tools/env.sh

# режим запуска geobase - использовать файл
export GEOBASE_MODE=bin

# запускаем TVM
source ./tools/run-tvm.sh

# скачиваем данные-ресурсы, если их нет или они старше одного дня
source ./tools/download-resources.sh

## Логи как в error booster
## Нужно запустить отдельно while true; do { echo -e 'HTTP/1.1 200 OK\r\n'; } | nc -l 12345; done
## и запустить с установленной переменной окружения EMULATE_EB=true ./tools/run-dev.sh
if [[ ${EMULATE_EB} == "true" ]]; then
    export ERROR_BOOSTER_HTTP_PORT=12345
    export ERROR_BOOSTER_HTTP_HOST=localhost
fi

# и запускаем приложение
./cmd/api/api
