#!/usr/bin/env bash
set -ex

cd $(dirname "${BASH_SOURCE[0]}")/..

# устанавливаем переменные окружения, необходимые для локального запуска
source ./tools/env.sh

# произвольные 32 символа, должны быть одинаковыми для поднятого TVM-демона и нашего приложения
export TVMTOOL_LOCAL_AUTHTOKEN=`echo $RANDOM | md5sum | head -c 32`

# запускаем TVM демона
pkill -f "tvmtool.*${LOCAL_TVM_PORT}" || true
tvmtool --port ${LOCAL_TVM_PORT} -c ./tools/tvmtool-config.json >& /tmp/tvmtool.log &

# нужно подождать пока поднимется tvm-tool
# TODO (simon-ekb): use ping, or something similar
sleep 10
