from yt.wrapper import YtClient, TablePath

from travel.avia.ad_feed.ad_feed.entities import SettlementId
from travel.avia.library.python.urls import TravelAviaCityLanding
from travel.avia.ad_feed.ad_feed.city_url.getter import CityUrlGetter


def create_by_yt_tables(
    travel_host: str, has_landing_table: str, slug_list_table: str, yt_client: YtClient
) -> CityUrlGetter:
    builder = TravelAviaCityLanding(travel_host=travel_host)
    cities_with_landing = {
        SettlementId(row['id'])
        for row in yt_client.read_table(
            TablePath(
                has_landing_table,
                columns=('id',),
            )
        )
    }
    slug_by_city = {
        SettlementId(row['Id']): row['Slug']
        for row in yt_client.read_table(
            TablePath(
                slug_list_table,
                columns=('Id', 'Slug'),
            )
        )
    }
    return CityUrlGetter(url_builder=builder, cities_with_landing=cities_with_landing, slug_by_city=slug_by_city)
