from typing import Optional

from travel.avia.ad_feed.ad_feed.entities import SettlementId
from travel.avia.library.python.urls import TravelAviaCityLanding


class CityUrlGetter:
    def __init__(
        self,
        url_builder: TravelAviaCityLanding,
        cities_with_landing: set[SettlementId],
        slug_by_city: dict[SettlementId, str],
    ):
        self._url_builder = url_builder
        self._cities_with_landing = cities_with_landing
        self._slug_by_city = slug_by_city

    def url(self, city_id: SettlementId) -> Optional[str]:
        if city_id not in self._cities_with_landing:
            return None
        return self._url_builder.url(to_slug=self._slug_by_city[city_id])
