import csv
from typing import Callable, Any, Iterator, IO


class CsvConverter:
    def __init__(self, mapper: dict[str, Callable[[str, Any], Any]]):
        self._mapper = mapper

    def convert(self, input_data: Iterator[dict[str, Any]], output: IO[Any]) -> None:
        writer = csv.DictWriter(
            output,
            self._mapper.keys(),
            restval='',
            dialect='excel',
            delimiter=',',
            extrasaction='ignore',
            quoting=csv.QUOTE_ALL,
            quotechar='"',
        )
        writer.writeheader()
        for row in input_data:
            converted_row = {key: mapper(key, row) for key, mapper in self._mapper.items()}
            writer.writerow(converted_row)
