import logging
import os
import sys
from argparse import ArgumentParser

from travel.avia.ad_feed.ad_feed.direction_type import DirectionTypeResolver
from travel.avia.library.python.lib_yt.cache import Station, Settlement
from travel.avia.library.python.lib_yt.client import configured_client
from yt.wrapper import YtClient

log = logging.getLogger(__name__)


def run(client: YtClient, point_from: str, point_to: str):
    resolver = DirectionTypeResolver(
        Station(client),
        Settlement(client),
    )
    log.info('Point from type: %s', resolver.for_point(point_from))
    log.info('Point to type: %s', resolver.for_point(point_to))
    log.info('Direction type: %s', resolver.for_direction(point_from, point_to))


def main():
    logging.basicConfig(
        level=logging.INFO,
        stream=sys.stdout,
    )

    parser = ArgumentParser()

    parser.add_argument('--yt-proxy', type=str, choices=('hahn', 'arnold'), default='hahn')
    parser.add_argument('--yt-token', type=str, default=os.getenv('YT_TOKEN'))

    parser.add_argument('from_code', type=str, help='Geo point code, like "c213", "s60814", "l225"')
    parser.add_argument('to_code', type=str, help='Geo point code, like "c213", "s60814", "l225"')

    arguments = parser.parse_args()

    log.info('From %s to %s', arguments.from_code, arguments.to_code)

    run(
        configured_client(arguments.yt_proxy, arguments.yt_token),
        arguments.from_code,
        arguments.to_code,
    )


if __name__ == '__main__':
    main()
