import datetime
from collections import namedtuple
from typing import NewType

import enum
from pydantic import BaseModel, Field


class NationalVersion(str, enum.Enum):
    RU = 'ru'
    UA = 'ua'
    KZ = 'kz'
    COM = 'com'
    TR = 'tr'


class S3ObjectInfo(BaseModel):
    last_modified: datetime.datetime = Field(alias='LastModified')


StationId = NewType('StationId', int)
SettlementId = NewType('SettlementId', int)
Direction = namedtuple('Direction', ('from_id', 'to_id'))
