import itertools
from typing import Iterator

from travel.avia.ad_feed.ad_feed.feed_generator.direction import DirectionFeedRow
from travel.avia.ad_feed.ad_feed.supplier import CityAliasSupplier


class DirectionCityAliasAdder:
    def __init__(self, city_alias_supplier: CityAliasSupplier):
        self._city_alias_supplier = city_alias_supplier

    def __call__(self, stream: Iterator[DirectionFeedRow]) -> Iterator[DirectionFeedRow]:
        aliases = self._city_alias_supplier.aliases
        for row in stream:
            yield row
            departure_aliases = aliases[row.departure_settlement_id]
            arrival_aliases = aliases[row.arrival_settlement_id]
            for departure, arrival in itertools.product(departure_aliases, arrival_aliases):
                yield row.copy(
                    update={
                        'departure_settlement_title': departure.title,
                        'departure_settlement_title_from': departure.title_from,
                        'arrival_settlement_title': arrival.title,
                        'arrival_settlement_title_to': arrival.title_to,
                    }
                )
            for departure in departure_aliases:
                yield row.copy(
                    update={
                        'departure_settlement_title': departure.title,
                        'departure_settlement_title_from': departure.title_from,
                    }
                )
            for arrival in arrival_aliases:
                yield row.copy(
                    update={
                        'arrival_settlement_title': arrival.title,
                        'arrival_settlement_title_to': arrival.title_to,
                    }
                )
