from typing import Callable, Any, Iterator

from travel.avia.ad_feed.ad_feed.feed_generator.abstract import T, IFeedGenerator


class Pipeline(IFeedGenerator[T]):
    def __init__(self, transformations: list[Callable[[Iterator[Any]], Iterator[Any]]]):
        self._transformations = transformations

    def __call__(self, stream: Iterator[T]) -> Iterator[T]:
        for t in self._transformations:
            stream = t(stream)
        yield from stream

    def generate_feed(self) -> Iterator[T]:
        yield from self(iter(()))
