from typing import TypeVar

from yt.wrapper import YtClient

from travel.avia.ad_feed.ad_feed.dumper import YtDumper
from travel.avia.ad_feed.ad_feed.feed_generator.abstract import IFeedGenerator

T = TypeVar('T')


def run(
    generator: IFeedGenerator[T],
    client: YtClient,
    output_table: str,
) -> None:
    YtDumper(client=client).dump(generator.generate_feed(), output_table=output_table)  # type: ignore
