from typing import Type
import enum

import click


class EnumType(click.Choice):
    def __init__(self, enum: Type[enum.Enum], *args, **kwargs):  # type: ignore
        self._enum = enum
        super().__init__(enum.__members__, *args, **kwargs)

    def convert(self, value, param, ctx):  # type: ignore
        return self._enum[super().convert(value, param, ctx)]
