from pydantic import BaseSettings


class YtSettings(BaseSettings):
    proxy: str = 'hahn'
    token: str

    class Config:
        env_prefix = 'YT_'


class YqlSettings(BaseSettings):
    token: str

    class Config:
        env_prefix = 'YQL_'


class MdsSettings(BaseSettings):
    access_key_id: str
    access_key_secret: str
    endpoint: str = 'https://s3.mdst.yandex.net'

    class Config:
        env_prefix = 'MDS_'


class CityAliasSettings(BaseSettings):
    table: str = '//home/avia/testing/data/ad-feed/ru/city_alias_list'

    class Config:
        env_prefix = 'CITY_ALIAS_'
