from collections import defaultdict
from functools import cached_property

from pydantic import BaseModel
from yt.wrapper import YtClient, TablePath

from travel.avia.ad_feed.ad_feed.entities import SettlementId


class Alias(BaseModel):
    id: SettlementId
    title: str
    title_from: str
    title_to: str
    official: str


def _convert_city_id(value: str) -> SettlementId:
    return SettlementId(int(value[1:]))


class CityAliasSupplier:
    def __init__(self, table_path: str, client: YtClient):
        self._table_path = table_path
        self._client = client

    @cached_property
    def aliases(self) -> dict[SettlementId, list[Alias]]:
        result = defaultdict(list)
        for row in self._client.read_table(
            TablePath(self._table_path, columns=('id', 'title', 'title_from', 'title_to', 'official'))
        ):
            row['id'] = _convert_city_id(row['id'])
            current = Alias.parse_obj(row)
            result[current.id].append(current)
        return result
