# -*- coding: utf-8 -*-

from django.contrib import admin

from travel.avia.admin.lib.admin_options import RaspExportModelAdmin

from .models import Script, UserPermission


class ScriptAdmin(RaspExportModelAdmin):
    list_display = ('code', 'title', 'on_work', 'on_service', 'on_migration')
    list_filter = ('on_work', 'on_service', 'on_migration')


admin.site.register(Script, ScriptAdmin)


class UserPermissionAdmin(RaspExportModelAdmin):
    raw_id_fields = ('script', 'user')

    list_display = ('script', 'user', 'can_run')
    list_filter = ('script', 'user')


admin.site.register(UserPermission, UserPermissionAdmin)
