# -*- coding: utf-8 -*-
import logging

from optparse import make_option

from django.core.management import BaseCommand, CommandError
from travel.avia.admin.lib.script_helpers.script_runner import script_runner

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = u'Запускаем задачу'

    option_list = BaseCommand.option_list + (
        make_option(
            '--code',
            dest='code',
            help=u'код скрипта'
        ),
    )

    def _log_and_raise(self, message):
        log.error(message)
        raise CommandError(message)

    def handle(self, **options):
        if not options['code']:
            self._log_and_raise('code is required parameter.')
        code = options['code'].strip()

        log.info('Run script: %s', code)

        task_status, error = script_runner.run_in_another_process(code)

        if error:
            self._log_and_raise(error)

        log.info('Script is %s', 'success' if task_status else 'failed')
