# encoding: utf-8

from django import template
from travel.avia.library.python.common.models.schedule import Company, RThread
from travel.avia.library.python.common.models.transport import TransportModel
from travel.avia.admin.www.models.schedule import TransportScheme


register = template.Library()


@register.simple_tag
def foreign_objects(obj_id, cls, cls2, title):
    """ Выводит ссылки на объекты класса <cls> (Эти объекты ссылаются на данный)
        либо "отсутствуют"
        либо "" в случае ошибки
        Вход: id объекта на который ссылаются,
              класс объекта, на который ссылаются
              класс объектов, которые ссылаются, либо имя аттрибута foreign manager
              имя атрибута для title-а в теге <a href="..">{title}</a>
        Выход: html
    """
    foreign_name = isinstance(cls2, basestring) and cls2 or (cls2.__name__.lower() + "_set")
    try:
        obj = cls.objects.get(id=int(obj_id))
    except:
        return ""
    objects = map(
        lambda o: '<a href="../../%s/%s/">%s</a>' % (
            str(o.__class__.__name__).lower(), str(o.id),
            getattr(o, title) or str(o) or 'названия нет'
        ),
        getattr(obj, foreign_name).all()
    )

    return objects and "&nbsp;".join(objects) or u"отсутствуют"


@register.simple_tag
def tm_scheme_objects(obj_id):
    return foreign_objects(obj_id, TransportModel, TransportScheme, 'title')


@register.simple_tag
def comp_scheme_f_objects(obj_id):
    return foreign_objects(obj_id, Company, TransportScheme, 'title')


@register.simple_tag
def thread_thread_f_objects(obj_id):
    return foreign_objects(obj_id, RThread, 'thread_changes', 'number')
