# -*- coding: utf-8 -*-
# Костыль для переезда на новую джангу

try:
    from django.contrib.admin.templatetags.admin_static import *  # noqa
except ImportError:
    from urlparse import urljoin

    from django.conf import settings  # noqa
    from django.template import Library

    register = Library()

    from django.templatetags.static import PrefixNode

    @register.simple_tag
    def static(path):
        return urljoin(PrefixNode.handle_simple("ADMIN_MEDIA_PREFIX"), "/".join(path.split('/')[1:]))

    static = register.simple_tag(static)
