# -*- coding: utf-8 -*-

from filebrowser.sites import site as filebrowser_site

from django.contrib import admin

from django.conf.urls import url, include

from travel.avia.admin.admin.views import (
    quick_tree_planet, quick_tree_country, quick_tree_region, quick_tree_settlement, quick_tree_station, copy_thread,
    show_file, download_db_file, delete_db_file, recalc_static_pages, load_schemas_zip_file,
    externaldirection_edit_schema, externaldirection_stations, upload_schedule_file, upload_railway_file,
    sindbad_stats, gtfs_form, get_configuration, get_settings
)
from travel.avia.admin.admin.views.partnerka import PrepareReport, Report, TryGetReport

# admin.autodiscover()

urlpatterns = [
    url(r'^www_stations/', include('travel.avia.admin.admin.www_stations.urls')),

    url(r'^reports/', include('travel.avia.admin.admin.reports.urls')),
    url(r'^stats/', include('travel.avia.admin.stats.urls')),

    url(r'^quick_tree/?$', quick_tree_planet, name="admin_tree"),
    url(r'^quick_tree/planet/(?P<id>\d+)', quick_tree_planet, name="admin_tree_planet"),
    url(r'^quick_tree/country/(?P<id>\d+)', quick_tree_country, name="admin_tree_country"),
    url(r'^quick_tree/region/(?P<id>\d+)', quick_tree_region, name="admin_tree_region"),
    url(r'^quick_tree/settlement/(?P<id>\d+)', quick_tree_settlement, name="admin_tree_settlement"),
    url(r'^quick_tree/station/(?P<id>\d+)', quick_tree_station, name="admin_tree_station"),

    url(r'^www/rthread/copy_thread/$', copy_thread),

    url(r'^show_file/(?P<app_label>[A-Za-z_]+)/(?P<model>[A-Za-z_]+)/(?P<field_name>[A-Za-z_]+)/(?P<id>\d+)', show_file),
    url(r'download_db_file/(?P<app_label>[A-Za-z_]+)/(?P<model_name>[A-Za-z_]+)/(?P<pk>\d+)/(?P<field_name>[A-Za-z_]+)',
        download_db_file, name='admin_download_db_file'),
    url(r'delete_db_file/(?P<app_label>[A-Za-z_]+)/(?P<model_name>[A-Za-z_]+)/(?P<pk>\d+)/(?P<field_name>[A-Za-z_]+)',
        delete_db_file, name='admin_delete_db_file'),

    url(r'^recalc_static_pages', recalc_static_pages, name="recalc_static_pages"),

    url(r'^www/externaldirection/load_zip_file/$', load_schemas_zip_file),
    url(r'^www/externaldirection/(?P<pk>\d+)/schema/$', externaldirection_edit_schema),
    url(r'^www/externaldirection/(?P<pk>\d+)/stations/$', externaldirection_stations),

    url(r'^upload_schedule_file', upload_schedule_file, name="upload_schedule_file"),
    url(r'^upload_railway_file', upload_railway_file, name="upload_railway_file"),

    url(u'^sindbad_stats/$', sindbad_stats),
    url(u'^gtfs_form/$', gtfs_form, name='admin_gtfs_form'),

    url(r'^filebrowser/', include(filebrowser_site.urls)),
    url(r'configuration/$', get_configuration, name='configuration'),
    url(r'settings/$', get_settings, name='settings'),

    url(r'partnerka/prepare_report$', PrepareReport.as_view(), name='partnerka.prepare_report'),
    url(r'partnerka/report$', Report.as_view(), name='partnerka.report'),
    url(r'partnerka/try_get_report$', TryGetReport.as_view(), name='partnerka.try_get_report'),

    url(r'', include(admin.site.urls)),
]
