# -*- coding: utf-8 -*-

from django.http import HttpResponseForbidden


def permission_required_or_403(func, key):
    def wrapper(request, *args, **kwargs):
        if not request.user.has_perm(key):
            return HttpResponseForbidden()

        return func(request, *args, **kwargs)

    return wrapper
