# -*- coding: utf-8 -*-

from travel.avia.library.python.common.models.geo import StationMajority, Station  # noqa
from travel.avia.library.python.common.models.transport import TransportType


def _station_suggest_json(suggest):
    station = Station.objects.get(id=suggest.object_id)

    return station_json(station)


def station_json(station):
    return {
        'id': station.id,
        'title': u'%s (%s)' % (station.L_title(), station.t_type.code),
        'lon': station.longitude,
        'lat': station.latitude,
        't_type_id': station.t_type_id,
        't_type': TransportType.objects.get(id=station.t_type_id).code
    }


def object_json(o):
    return {
        'id': o.id if o else '',
        'title': o.L_title() if o else ''
    }


def object_with_code_json(o):
    return {
        'id': o.id if o else '',
        'code': o.code if o else '',
        'title': o.L_title() if o else ''
    }


def packages_json(o):
    return {
        'id': o.id,
        'title': o.title,
        't_type_code': o.t_type.code
    }
