# -*- coding: utf-8 -*-

from django.contrib import admin
from django.contrib.admin import SimpleListFilter
from django import forms
from django.db import models
from django.utils.safestring import mark_safe
from django.utils.decorators import method_decorator
from django.views.decorators.csrf import csrf_exempt, csrf_protect
from django.core.files.uploadhandler import TemporaryFileUploadHandler
from django.utils.translation import ugettext_lazy as _

from travel.avia.admin.lib.admin_options import RaspExportModelAdmin
from .models import SettlementImage


class SettlementNullFilter(SimpleListFilter):
    title = _(u'Есть город')
    parameter_name = 'settlement'

    def lookups(self, request, model_admin):
        return (
            ('1', _(u'Да'), ),
            ('0', _(u'Нет'), ),
        )

    def queryset(self, request, queryset):
        kwargs = {self.parameter_name: None}

        if self.value() == '0':
            return queryset.filter(**kwargs)
        if self.value() == '1':
            return queryset.exclude(**kwargs)

        return queryset


class ImageInput(forms.ClearableFileInput):

    def render(self, name, value, attrs=None):
        # редактировать можно только оригинальную картинку
        if name == 'img_orig':
            html = super(ImageInput, self).render(name, value, attrs)

            if value:
                html += mark_safe('<br><img src="%s">' % value.url)

            return html

        if value:
            return mark_safe('<img src="%s">' % value.url)

        return ''


csrf_exempt_m = method_decorator(csrf_exempt)


class SettlementImageAdmin(RaspExportModelAdmin):
    list_display = ('settlement', 'img_orig')
    raw_id_fields = ('settlement',)
    list_filter = (SettlementNullFilter,)

    formfield_overrides = {
        models.ImageField: {'widget': ImageInput}
    }

    @csrf_exempt_m
    def add_view(self, request, *args, **kwargs):
        request.upload_handlers = [TemporaryFileUploadHandler()]

        view = super(SettlementImageAdmin, self).add_view
        return csrf_protect(view)(request, *args, **kwargs)

    @csrf_exempt_m
    def change_view(self, request, *args, **kwargs):
        request.upload_handlers = [TemporaryFileUploadHandler()]

        view = super(SettlementImageAdmin, self).change_view
        return csrf_protect(view)(request, *args, **kwargs)

admin.site.register(SettlementImage, SettlementImageAdmin)
