# -*- coding: utf-8 -*-

import os
import subprocess

from django.conf import settings
from django.core.files.uploadedfile import SimpleUploadedFile
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.models_abstract.geo import BaseSettlementImage


class SettlementImage(BaseSettlementImage):
    class Meta(BaseSettlementImage.Meta):
        verbose_name = _(u'Изображение города')
        verbose_name_plural = _(u'Изображение городов')
        app_label = 'api'
        db_table = 'api_settlementimage'

    def resize(self, filepath, prefix, options):
        path = os.path.dirname(filepath)
        name = os.path.basename(filepath)

        result_name = u'%s_%s' % (prefix, name)
        result_path = os.path.join(path, result_name)

        command = ['convert', filepath] + options + [result_path]
        output, error = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()

        if error:
            raise Exception(error)

        command = ['jpegtran', '-copy', 'none', '-optimize', '-progressive', '-outfile', result_path, result_path]

        output, error = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()

        if error:
            raise Exception(error)

        return SimpleUploadedFile(result_name, open(result_path, "rb").read(), content_type='image/jpeg')

    def resize_small(self, filepath):
        options = ['-quality', '90', '-resize', '550x']

        self.img_small = self.resize(filepath, 'small', options)

    def resize_large(self, filepath):
        options = ['-quality', '95', '-resize', '1200x', '-gravity', 'center', '-crop', '1200x350+0+0']

        self.img_large = self.resize(filepath, 'large', options)

    def save(self, *args, **kwargs):
        if self.img_orig and self.img_orig.file:
            filepath = self.img_orig.file.temporary_file_path()

            for size, album in settings.INTERCITY_IMAGE_SIZE_ALBUMS.iteritems():
                if size == 'orig':
                    continue

                width, height = size.split('x')

                resize_opt = '{width}x'.format(width=width)
                crop_opt = '{size}+0+0'.format(size=size)

                options = ['-quality', '92', '-resize', resize_opt, '-gravity', 'center', '-crop', crop_opt]

                img = self.resize(filepath, size, options)

                field = 'img_{width}'.format(width=width)

                setattr(self, field, img)

        super(SettlementImage, self).save(*args, **kwargs)
