# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import sys

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.admin.local_settings')


def gunicorn():
    from library.python.gunicorn import run_standalone
    from travel.avia.admin import wsgi

    run_standalone(wsgi.application)


def manage():
    from django.core.management import execute_from_command_line

    print('Loading manage.py')
    execute_from_command_line(sys.argv)


def run_command():
    import django
    django.setup()

    from subprocess import check_call

    from django.conf import settings

    from travel.avia.admin.lib.arcadia.convert_command import convert_to_arcadia

    assert len(sys.argv) >= 2, 'Need command to execute'
    command = sys.argv[1]
    y_python_entry_point = convert_to_arcadia(command)

    command_env = os.environ.copy()
    command_env['Y_PYTHON_ENTRY_POINT'] = y_python_entry_point
    check_call(
        [settings.APPLICATION_BINARY] + sys.argv[2:],
        env=command_env,
    )
