# -*- coding: utf-8 -*-
import logging
import sys


LOGGING_VERBOSITY = {
    0: None,
    1: logging.ERROR,
    2: logging.INFO,
    3: logging.DEBUG,
}


class FilterLevelLessThan(logging.Filter):
    def __init__(self, level):
        self._level = level

    def filter(self, record):
        return int(record.levelno < self._level)


def setup_logger_verbosity(log, verbosity, stdout, stderr):
    log_level = LOGGING_VERBOSITY.get(verbosity)
    if log_level is None:
        return

    h = logging.StreamHandler(stderr)
    h.setLevel(max(log_level, logging.ERROR))
    log.addHandler(h)

    h = logging.StreamHandler(stdout)
    h.setLevel(log_level)
    h.addFilter(FilterLevelLessThan(logging.ERROR))
    log.addHandler(h)

    log.setLevel(log_level)


def setup_logger(logger, verbosity, add_stdout_handler=False, formatter=None):
    loglevel = {
        0: logging.WARN,
        1: logging.INFO,
        2: logging.DEBUG,
        3: logging.ERROR,
    }[verbosity]
    logger.setLevel(loglevel)

    if add_stdout_handler:
        h = logging.StreamHandler(sys.stdout)
        h.setLevel(loglevel)
        if formatter is not None:
            h.setFormatter(formatter)
        logger.addHandler(h)
