# -*- coding: utf-8 -*-
import itertools


def toposort(connections):
    if not connections:
        return

    data = {k: set(v) for k, v in collect_values(connections).items()}

    # Ignore self dependencies
    for k, v in data.items():
        v.discard(k)

    independed = set().union(*(data.values())) - set(data.keys())
    data.update({item: set() for item in independed})
    while True:
        ordered = set(item for item, dep in data.items() if not dep)
        if not ordered:
            break
        yield ordered
        data = {
            item: (dep - ordered) for item, dep in data.items()
            if item not in ordered
        }
    if len(data) != 0:
        raise CyclicDependency(data.items())


class CyclicDependency(Exception):
    pass


def show_cycle(nodes, relations_map):
    return ''.join(_show_cycle(nodes, relations_map))


def _show_cycle(nodes, relations_map):
    if not nodes:
        return
    for pair in pairwise(nodes + [nodes[0]]):
        first, _ = pair
        yield '{}.({}) -> '.format(first, ','.join(relations_map[pair]))
    yield nodes[0]


def pairwise(iterable):
    "s -> (s0,s1), (s1,s2), (s2, s3), ..."
    a, b = itertools.tee(iterable)
    next(b, None)
    return itertools.izip(a, b)


def collect_values(pairs):
    """ [(k, v)] -> {k: [v]} """
    d = {}
    for k, v in pairs:
        d.setdefault(k, []).append(v)
    return d
