# -*- coding: utf-8 -*-
import re

from travel.avia.library.python.avia_data.models.amadeus_merchant import AmadeusMerchant  # noqa
from travel.avia.library.python.common.models.currency import Currency
from travel.avia.library.python.common.models.geo import CityMajority
from travel.avia.library.python.common.models.geo import CodeSystem
from travel.avia.library.python.common.models.geo import Country
from travel.avia.library.python.common.models.geo import District  # noqa
from travel.avia.library.python.common.models.geo import PointSynonym
from travel.avia.library.python.common.models.geo import Region
from travel.avia.library.python.common.models.geo import Settlement
from travel.avia.library.python.common.models.geo import SettlementCode
from travel.avia.library.python.common.models.geo import SettlementRelatedStations
from travel.avia.library.python.common.models.geo import Station
from travel.avia.library.python.common.models.geo import StationCode
from travel.avia.library.python.common.models.geo import StationMajority
from travel.avia.library.python.common.models.geo import StationType
from travel.avia.library.python.common.models.iatacorrection import IataCorrection
from travel.avia.library.python.common.models.partner import Partner  # noqa
from travel.avia.library.python.common.models.schedule import Company, AviaAlliance
from travel.avia.library.python.common.models.transport import TransportModel
from travel.avia.library.python.common.models.transport import TransportType


class FK(object):
    def __init__(self, field, model):
        self.field = field
        self.model = model


class FILE(object):
    def __init__(self, field):
        self.field = field


def L_field(field, add_local_field=False, extra=None):
    fields = [field + '_' + lang for lang in ['ru', 'en', 'tr', 'uk']]
    if add_local_field:
        fields = [field] + fields
    if extra:
        fields += [
            '%s_%s_%s' % (field, lang, case)
            for lang, cases in extra.items()
            for case in cases
        ]
    return fields


NEW_RASP_SYNC_MODELS = {
    AviaAlliance,
    Company,
    Country,
    Currency,
    PointSynonym,
    Region,
    Settlement,
    Station,
}

IMPORT_MODELS = [
    {
        'model': Company,
        'fields': [
            FK('home_station', Station),  # home_station = models.ForeignKey('www.Station', verbose_name=_(u'главная станция'), null=True, blank=True)
            FK('t_type', TransportType),  # t_type = models.ForeignKey('www.TransportType', verbose_name=_(u'тип транспорта'), null=True, blank=True, default=None)
            FK('country', Country),  # country = models.ForeignKey('Country', verbose_name=_(u'страна'), null=True, blank=True, default=None)
            FK('alliance', AviaAlliance),  # alliance = models.ForeignKey('AviaAlliance', verbose_name=_(u'Авиа-альянс'), null=True, blank=True, related_name='companies')
            'address',  # address = models.CharField(verbose_name=_(u'адрес'), max_length=255, null=True, blank=True)
            'supplier_code',  # supplier_code = CodeCharField(verbose_name=_(u'код Поставщика Данных'), max_length=255, null=True, blank=True, default=None, unique=True)
            'sirena_id',  # sirena_id = CodeCharField(verbose_name=_(u'код Сирена'), max_length=100, null=True, blank=True, default=None, unique=True)
            'iata',  # iata = CodeCharField(verbose_name=_(u'код IATA'), max_length=100, null=True, blank=True, default=None, db_index=True)
            'icao',  # icao = CodeCharField(verbose_name=_(u'код ICAO'), max_length=100, null=True, blank=True, unique=True)
            'icao_ru',  # icao_ru = CodeCharField(verbose_name=_(u'код ICAO(рус)'), max_length=100, null=True, blank=True, unique=True)
            'is_freight',  # is_freight = models.BooleanField(_(u"Грузовая компания"), default=False, help_text=_(u"Не импортируем такие компании от OAG"))
            'priority',  # priority = models.IntegerField( null=False, blank=True, default=0, help_text=_(u'Приоритет для различения компаний с одним иата-кодом'))
            L_field('new_L_title', add_local_field=True,
                    extra={'ru': ['nominative', 'genitive', 'accusative', 'locative'], 'en': ['nominative'],
                           'uk': ['nominative'], 'tr': ['nominative']}),
            L_field('title', add_local_field=True),  # L_title = L_field(_(u'название'), add_local_field=True)
            L_field('short_title', add_local_field=True),  # L_short_title = L_field(_(u'краткое название'), add_local_field=True)

            'url',  # url = models.URLField(verbose_name=_(u'урл сайта'), max_length=255, null=True, blank=True)

            L_field('registration_url', add_local_field=True),  # L_registration_url = L_field(_(u'Url регистрации'), add_local_field=True, default='', blank=True, null=True, max_length=255)
            L_field('registration_phone', add_local_field=True),  # L_registration_phone = L_field(_(u'Телефон регистрации'), add_local_field=True, default='', blank=True, null=True, max_length=255)

            'email',  # email = models.EmailField(verbose_name=_(u'email'), max_length=255, null=True, blank=True)
            'contact_info',  # contact_info = models.TextField(verbose_name=_(u'контактная информация'), null=True, blank=True, default=None)
            'phone',  # phone = TrimmedCharField(verbose_name=_(u'контактный телефон'), max_length=255, null=False, default='', blank=True)
            'phone_booking',  # phone_booking = TrimmedCharField(verbose_name=_(u'телефон для бронирования'), max_length=255, null=False, default='', blank=True)
            'description',  # description = models.TextField(verbose_name=_(u'описание'), null=True, blank=True, default=None)

            FILE('logo'),  # logo = models.ImageField(verbose_name=_(u'логотип'), upload_to='data/company/logo', null=True, blank=True, default=None)
            FILE('icon'),  # icon = models.ImageField(verbose_name=_(u'иконка'), upload_to='data/company/icon', null=True, blank=True, default=None)
            FILE('logo_mono'),  # logo_mono = models.ImageField(verbose_name=_(u'логотип без фона'), upload_to='data/company/logo_mono', null=True, blank=True, default=None)
            FILE('svg_logo'),  # svg_logo = models.FileField(verbose_name=_(u'svg логотип'), upload_to='data/company/svg', null=True, blank=True, default=None)
            FILE('svg2png_logo'),  # svg2png_logo = models.ImageField( verbose_name=_(u'Рендеренный svg2png логотип'), upload_to=get_svg2png_logo_upload_to, storage=ReplaceableFileSystemStorage(), null=True, blank=True, default=None)  # noqa

            'hidden',  # hidden = models.BooleanField(verbose_name=_(u'не показывать нигде!'), default=False)
            'strange',  # strange = models.BooleanField(verbose_name=_(u'не понятные перевозчики'), default=False)

            'meta_title',  # meta_title = models.CharField(max_length=255, verbose_name=_(u'meta title'), null=True, blank=True)
            'meta_description',  # meta_description = models.TextField(verbose_name=_(u'meta description'), null=True, blank=True)

            L_field('bonus_name', add_local_field=True),  # L_bonus_name = L_field(_(u'название программы для часто летающих пассажиров'), default=u'', max_length=255, blank=True, add_local_field=True)  # noqa
        ],
    },
    {
        'model': TransportModel,
        'fields': [
            'code',  # code = CodeCharField(verbose_name=_(u'код'), max_length=10, null=True, blank=True, default=None, unique=True)
            'code_en',  # code_en = CodeCharField(verbose_name=_(u'код Английский'), max_length=10, null=True, blank=True, default=None, unique=True)

            'title',  # title = models.CharField(verbose_name=_(u'наименование'), max_length=100)
            'title_en',  # title_en = models.CharField(verbose_name=_(u'англ. наименование'), default=u'', blank=True, max_length=100)

            FK('t_type', TransportType),  # t_type = models.ForeignKey('www.TransportType', verbose_name=_(u'тип'))
            # FK('t_subtype', TransportSubtype),  # t_subtype = models.ForeignKey('www.TransportSubtype', verbose_name=_(u'подтип'), default=None, blank=True, null=True)
            # FK('producer', VehicleProducer),  # producer = models.ForeignKey('www.VehicleProducer', verbose_name=_(u'производитель'), null=True, blank=True, default=None)

            'plane_body_type',  # plane_body_type = models.CharField(verbose_name=_(u'тип фюзеляжности самолёта'), max_length=10, null=True, blank=True, choices=TYPES)
            'is_propeller_flight',  # is_propeller_flight = models.BooleanField(verbose_name=_(u'винтовой самолёт'), default=False)

            'template_page',  # template_page = models.CharField(verbose_name=_(u'имя шаблона'), max_length=100, null=True, blank=True)
            'ttx',  # ttx = models.TextField(verbose_name=_(u'тТХ'), null=True, blank=True, default=None)
            'descr',  # descr = models.TextField(verbose_name=_(u'описание'), null=True, blank=True, default=None)
            'is_cargo',  # is_cargo = models.BooleanField(verbose_name=_(u"грузовой"), blank=True,

            FILE('img'),  # img = models.ImageField(verbose_name=_(u'фото ТС'), upload_to='data/transportmodel/img', null=True, blank=True, default=None)
            FILE('background'),  # background = models.ImageField(verbose_name=_(u'картинка для фона'), upload_to='data/transportmodel/background', null=True, blank=True, default=None)
        ],
    },
    {
        'model': IataCorrection,
        'fields': [
            'code',  # CodeCharField(u'Код IATA', max_length=4, blank=False)
            'number',  # RegExpField(u'Номер рейса', max_length=1000, help_text=(u'Номер без кода. Можно задавать регулярным выражением'))
            FK('company', Company),  # models.ForeignKey('www.Company', null=False, blank=False)
        ]
    },
    {
        'model': Country,
        'fields': [
            # L_title = Geobase_L_title(_(u'наименование'), add_local_field=True, local_field_critical=True, extra={ 'ru': [ ('preposition_v_vo_na', L_field.char_field(_(u'предлог (в, во, на)'), max_length=2)), # prefix_in ('genitive', L_field.char_field(_(u'наименование (род. падеж'))), # title_of ('locative', L_field.char_field(_(u'наименование (местный. падеж)'))) # title_in ], 'uk': [ # В геобазе нет винительного падежа у стран ('accusative', L_field.char_field(_(u'наименование (вин. падеж) (uk)'))), ] })  # noqa
            L_field('title', add_local_field=True,  extra={
                'ru': ['preposition_v_vo_na', 'genitive', 'locative'],
                'en': ['nominative'],
                'uk': ['nominative', 'accusative'],
                'tr': ['nominative'],
            }),

            FK('currency', Currency),  # currency = models.ForeignKey('currency.Currency', verbose_name=_(u'валюта'), null=True, blank=True, default=None)

            'code',  # code = CodeCharField(verbose_name=_(u'код страны ISO 2-alpha'), max_length=4, null=True, blank=True, default=None, unique=True)
            'code3',  # code3 = CodeCharField(verbose_name=_(u'код страны ISO 3166-1 3-alpha'), max_length=4, null=True, blank=True, default=None, unique=True)
            '_geo_id',  # _geo_id = models.IntegerField(verbose_name=_(u'geo ID'), null=True, blank=True, default=None, unique=True)
            '_kladr_id',  # _kladr_id = models.CharField(verbose_name=_(u'kladr ID'), max_length=50, null=True, blank=True, default=None, editable=False)
            'domain_zone',  # domain_zone = CodeCharField(verbose_name=_(u'имя доменной зоны IANA'), max_length=2, null=True, blank=True, default=None, unique=True, help_text=_(u"без точки: 'ru', 'us', 'uk'"))  # noqa

            # TODO Как тут быть?
            # 'synonyms',  # synonyms = generic.GenericRelation('PointSynonym')

            'language',  # language = CodeCharField( _(u'язык страны'), max_length=5, choices=[(k, _(v)) for k, v in LANGUAGES], default='ru',)
            # 'modified_at',  # modified_at = models.DateTimeField(_(u'Дата-время изменения'), auto_now=True, null=False, blank=True)

            L_field('new_L_title', add_local_field=True, extra={
                'ru': ['nominative', 'genitive', 'locative'],
                'en': ['nominative'],
                'uk': ['nominative', 'accusative'],
                'tr': ['nominative'],
            }),
        ],
    },
    {
        'model': TransportType,
        'fields': [
            'code',  # code = models.CharField(verbose_name=_(u'код'), max_length=50, unique=True, validators=[code_validator])
            L_field('title'),  # L_title = L_field(_(u'наименование'), base_field_critical=True, base_lang='ru')
            L_field('title_plural'),  # L_title_plural = L_field(_(u'наименование множественное'), base_lang='ru')
            L_field('station_name'),  # L_station_name = L_field(_(u'название станции'), base_lang='ru', help_text=_(u"например, для поездов - 'вокзал'."))
            L_field('station_name_plural'),  # L_station_name_plural = L_field(_(u'название станций'), base_lang='ru', help_text=_(u"например, для поездов - 'вокзалы'."))
            L_field('title_partner_page'),  # L_title_partner_page = L_field(_(u'название для страницы партнеров'), base_lang='ru')
        ],
    },
    {
        'model': StationType,
        'fields': [
            L_field('name',  extra={'ru': ['genitive', 'accusative', 'dative']}),  # L_name = L_field(_(u'название'), max_length=255, base_field_critical=True, base_lang='ru', extra={ 'ru': [ ('genitive', L_field.char_field(_(u'название в родительном падеже'))), # name_gen ('accusative', L_field.char_field(_(u'название в винительном падеже'))), # name_acc ('dative',  L_field.char_field(_(u'название в дательном падеже'))), # name_dat ] })  # noqa
            L_field('prefix'),  # L_prefix = L_field(_(u'префикс'), base_lang='ru', max_length=100)
            L_field('railway_prefix'),  # L_railway_prefix = L_field(_(u'префикс для жд'), base_lang='ru', max_length=100, help_text=_(u"для списка станций на странице жд рейса"))
            'title_regex',  # title_regex = RegExpField(verbose_name=_(u'шаблон названия станции'), null=True, blank=True, default=None, max_length=100)
            # Это поле могут заменить в rasp: FIXME: Заменить на OneToOneField(null=True), чтобы джанга не волновалась.
            FK('default_for_t_type', TransportType),  # default_for_t_type = models.ForeignKey('www.TransportType', null=True, unique=True, verbose_name=_(u"по умочанию для типа транспорта"), default=None, blank=True)  # noqa
        ],
    },
    {
        'model': SettlementCode,
        'fields': [
            'code',  # code = CodeCharField(verbose_name=_(u"код"), blank=False, null=False, max_length=50, db_index=True)
            FK('settlement', Settlement),  # settlement = models.ForeignKey(Settlement, verbose_name=_(u'город'), blank=False, null=False, related_name='code_set')
            FK('system', CodeSystem),  # system = models.ForeignKey(CodeSystem, verbose_name=_(u'система кодирования'), blank=False, null=False)
        ],
    },
    {
        'model': SettlementRelatedStations,
        'fields': [
            FK('settlement', Settlement),  # settlement = models.ForeignKey('Settlement', related_name='related_stations', verbose_name=_(u'город'))
            FK('station', Station),  # station = models.ForeignKey('Station', related_name='related_settlements', verbose_name=_(u'станция'))
        ],
    },
    {
        'model': Settlement,
        'fields': [
            FK('majority', CityMajority),  # majority = models.ForeignKey(CityMajority, verbose_name=_(u'важность города'), null=True, blank=True, default=None)
            FK('country', Country),  # country = models.ForeignKey(Country, verbose_name=_(u'страна'), null=True, blank=True, default=None)
            FK('region', Region),  # region = models.ForeignKey(Region, verbose_name=_(u'область'), null=True, blank=True, default=None)
            # FK('district', District),  # district = models.ForeignKey('District', null=True, blank=True, default=None, verbose_name=_(u"район"), related_name=u"settlements")

            L_field('title', add_local_field=True,  extra={'ru': ['preposition_v_vo_na', 'genitive', 'accusative', 'locative']}),  # L_title = L_title(_(u'наименование'), add_local_field=True, local_field_critical=True, db_index=True, extra={ 'ru': [ ('preposition_v_vo_na', L_field.char_field(_(u'предлог (в, во, на)'), max_length=2)), ('genitive', L_field.char_field(_(u'наименование (род. падеж)'))), ('accusative', L_field.char_field(_(u'наименование (вин. падеж)'))), ('locative', L_field.char_field(_(u'наименование (местн. падеж)'))), ] })  # noqa
            L_field('abbr_title', add_local_field=True),  # L_abbr_title = L_field(_(u'сокр. наименование'), add_local_field=True, max_length=4, help_text=_(u'максимум 4 символа'))

            'suggest_order',  # suggest_order = models.IntegerField(_(u'порядок в саджестах'), help_text=_(u'сначала выводятся города с меньшим значением'), null=False, default=100)
            'time_zone',  # time_zone = models.CharField(verbose_name=_(u'временная зона'), help_text=_(u'временная зона в международном формате'), null=False, blank=False, max_length=30)
            'phone_info',  # phone_info = models.CharField(verbose_name=_(u'тел. справочной'), max_length=20, null=True, blank=True, default=None)
            'phone_info_short',  # phone_info_short = models.CharField(verbose_name=_(u'короткий тел. справочной'), max_length=20, null=True, blank=True, default=None)
            '_geo_id',  # _geo_id = models.IntegerField(verbose_name=_(u'geo ID'), null=True, blank=True, default=None, unique=True)
            '_kladr_id',  # _kladr_id = models.CharField(verbose_name=_(u'kladr ID'), max_length=50, null=True, blank=True, default=None, editable=False)
            'sirena_id',  # sirena_id = CodeCharField(verbose_name=_(u'код в "Sirena"'), max_length=50, null=True, blank=True, default=None, unique=True)
            'iata',  # iata = CodeCharField(verbose_name=_(u'код IATA'), max_length=20, null=True, blank=True, default=None, unique=True)
            'koatuu',  # koatuu = CodeCharField(verbose_name=_(u'код КОАТУУ'), max_length=40, null=True, blank=True, default=None, unique=True, help_text=_(u"держа́вний класифіка́тор об'є́ктів адміністрати́вно-територіа́льного у́строю Украї́ни"))  # noqa
            'big_city',  # big_city = models.BooleanField(verbose_name=_(u'город на уровне столицы'), default=False)
            'hidden',  # hidden = models.BooleanField(verbose_name=_(u'не показывать нигде!'), default=False)
            # 'service_comment',  # service_comment = models.TextField(verbose_name=_(u'служебный комментарий'), help_text=_(u'не показывается в сервисе'), null=True, blank=True, default=None)
            'has_tablo',  # has_tablo = models.BooleanField(verbose_name=_(u'город имеет табло'), default=True, blank=False, null=False)
            'agent_geo_id',  # agent_geo_id = models.IntegerField(verbose_name=_(u'agent Geo ID'), null=True, blank=True, default=None)

            # TODO Как тут быть?
            # 'properties',  # properties = models.ManyToManyField(SettlementProperty, verbose_name=_(u'свойства'), blank=True, default=None)

            # TODO Нужен ли SuburbanZone ?
            # FK('suburban_zone', SuburbanZone),  # suburban_zone = models.ForeignKey("SuburbanZone", blank=True, null=True, verbose_name=_(u"пригородная зона"), help_text=_(u"пригородная зона, в которую входит город"), related_name="settlement_set")  # noqa

            # TODO Как тут быть?
            # 'synonyms',  # synonyms = generic.GenericRelation('PointSynonym')

            'has_many_airports',  # has_many_airports = models.BooleanField(verbose_name=_(u'много аэропортов'), default=False, null=False)
            'has_urban_transport',  # has_urban_transport = models.BooleanField(verbose_name=_(u'есть городской транспорт'), default=False, null=False)
            # 'human_url',  # human_url = CodeCharField(verbose_name=_(u'код города для ЧПУ'), max_length=50, null=True, blank=True, default=None, unique=True)
            # 'threads_amount',  # threads_amount = models.PositiveIntegerField(verbose_name=_(u'общее количество рейсов в табло'), default=0, editable=False)

            # 'type_choices',  # type_choices = models.CharField(verbose_name=_(u'типы ТС'), max_length=50, default='', null=False, blank=True)
            'longitude',  # longitude = models.FloatField(verbose_name=_(u"долгота"), default=None, blank=True, null=True, db_index=True)
            'latitude',  # latitude = models.FloatField(verbose_name=_(u"широта"), default=None, blank=True, null=True, db_index=True)
            '_disputed_territory',  # _disputed_territory = models.BooleanField(verbose_name=_(u"спорная территория"), default=False, db_column='disputed_territory')
            # 'modified_at',  # modified_at = models.DateTimeField(_(u'Дата-время изменения'), auto_now=True, null=False, blank=True)
            L_field('new_L_title', add_local_field=True, extra={
                'ru': [
                    'nominative',
                    'genitive',
                    'accusative',
                    'locative',
                ],
                'en': ['nominative'],
                'uk': ['nominative'],
                'tr': ['nominative'],
            }),
            L_field('new_L_abbr_title', add_local_field=True, extra={
                'ru': ['nominative'],
                'en': ['nominative'],
                'uk': ['nominative'],
                'tr': ['nominative'],
            }),
        ],
    },
    {
        'model': Station,
        'fields': [
            L_field('address', add_local_field=True),  # L_address = L_field(_(u'адрес'), add_local_field=True, max_length=200, null=True, blank=True, default=None)
            FK('majority', StationMajority),  # majority = models.ForeignKey('www.StationMajority', verbose_name=_(u'важность станции'), null=False, blank=False)
            FK('settlement', Settlement),  # settlement = models.ForeignKey('www.Settlement', verbose_name=_(u'город'), null=True, blank=True, default=None)
            # FK('district', District),  # district = models.ForeignKey('www.District', null=True, blank=True, default=None, verbose_name=_(u"район"))
            FK('region', Region),  # region = models.ForeignKey('www.Region', verbose_name=_(u'область'), null=True, blank=True, default=None)
            FK('country', Country),  # country = models.ForeignKey('www.Country', verbose_name=_(u'страна'), null=True, blank=True, default=None)

            FK('t_type', TransportType),  # t_type = models.ForeignKey('www.TransportType', verbose_name=_(u'тип транспорта'), default=1)

            # RASP-1546
            FK('station_type', StationType),  # station_type = models.ForeignKey('www.StationType', verbose_name=_(u'тип станции'), default=12)

            # TODO Нужен ли SuburbanZone ?
            # FK('suburban_zone', SuburbanZone),  # suburban_zone = models.ForeignKey("SuburbanZone", verbose_name=_(u'пригородная зона'), null=True, blank=True, default=None)

            # FK('supplier', Supplier),  # supplier = models.ForeignKey('www.Supplier', verbose_name=_(u'поставщик'), default=None, blank=True, null=True)
            'title',
            'popular_title',
            # Переводы
            L_field('new_L_title', add_local_field=True,  extra={'ru': ['nominative','genitive', 'accusative', 'locative'], 'en': ['nominative'], 'uk': ['nominative'], 'tr': ['nominative']}),  # L_title = L_field( _(u'наименование'), add_local_field=True, local_field_critical=True, add_override_field=True, db_index=True, extra={ 'ru': [ ('preposition_v_vo_na', L_field.char_field( _(u'предлог (в, во, на)'), max_length=2, help_text=_(u'в, во, на – направление: куда? (во Владимир, на ул. Пушкина)'),)), ('genitive', L_field.char_field( _(u"наименование (род. падеж)"), help_text=_( u'откуда? - от (кого? чего?) Москвы, из (кого? чего?) Москвы, табло (кого? чего?) Москвы'))), ('accusative', L_field.char_field( _(u'наименование (вин. падеж)'), help_text=_(u'куда? - в (кого? что?) Москву'))), ('locative', L_field.char_field( _(u"наименование (пред. падеж)"), help_text=_(u'где? - в (ком? чем?) Москве'))), ] })  # noqa
            L_field('new_L_popular_title', add_local_field=True,  extra={'ru': ['nominative'], 'en': ['nominative'], 'uk': ['nominative'], 'tr': ['nominative']}),  # L_popular_title = L_field( _(u'народное наименование'), add_local_field=True, db_index=True, extra={ 'ru': [ ('genitive', L_field.char_field( _(u'народное наименование (род. падеж)'), db_index=True, help_text=_( u'откуда? - от (кого? чего?) Москвы, из (кого? чего?) Москвы, табло (кого? чего?) Москвы'))), ] }, fallback_fields=['L_title'], help_text=_(u'популярное в народных массах название'),)  # noqa
            L_field('new_L_address'),
            # L_field('short_title', add_local_field=True),  # L_short_title = L_field( _(u'короткое наименование'), add_local_field=True, fallback_fields=['L_title'],)
            # L_field('how_to_get_to_city'),
            L_field('new_L_how_to_get_to_city'),

            'type_choices',  # type_choices = TrimmedCharField(_(u'типы отображения табло/расписания'), max_length=100, null=True, default=u'', blank=True)
            'hidden',  # hidden = models.BooleanField(help_text=_(u'не показывать нигде, кроме рейсов следования. ' u'Не давать ссылку в рейсе следования.'), verbose_name=_(u"скрыта"), default=False)
            'express_id',  # express_id = CodeCharField(max_length=50, null=True, blank=True, default=None, editable=False, unique=True)
            'sirena_id',  # sirena_id = CodeCharField(verbose_name=_(u'код в "Sirena"'), max_length=10, null=True, blank=True, default=None, editable=False, unique=True)

            'time_zone',  # time_zone = models.CharField(verbose_name=_(u'временная зона'), help_text=_(u'временная зона в международном формате'), null=False, blank=True, max_length=30)
            'time_zone_not_check',  # time_zone_not_check = models.BooleanField(verbose_name=_(u"не сверять временную зону с родительским регионом"), default=False)

            'site_url',  # site_url = models.URLField(verbose_name=_(u'урл сайта'), max_length=100, null=True, blank=True, default=None)

            # # FIXME: возможно не используемое поле, стоит его удалить
            # 'properties',  # properties = models.ManyToManyField('www.StationProperty', verbose_name=_(u'свойства'), blank=True, default=None)
            # # FIXME: возможно не используемое поле, стоит его удалить
            # '_majority',  # _majority = models.IntegerField(verbose_name=_(u'важность'), null=True, blank=True, default=None)

            # L_field('how_to_get_to_city'),  # L_how_to_get_to_city = L_field(_(u'как доехать до города'), null=True, blank=True, field_cls=models.TextField)
            'not_generalize',  # not_generalize = models.BooleanField( verbose_name=_(u'не обобщать до города при именовании рейсов'), blank=True, default=False)

            'longitude',  # longitude = models.FloatField(verbose_name=_(u"долгота"), default=None, blank=True, null=True, db_index=True)
            'latitude',  # latitude = models.FloatField(verbose_name=_(u"широта"), default=None, blank=True, null=True, db_index=True)

            # RASP-3160
            'map_zoom',  # map_zoom = models.IntegerField(verbose_name=_(u'масштаб карты'), default=None, blank=True, null=True)

            'use_direction',  # use_direction = models.CharField(verbose_name=_(u"связь с направлениями"), blank=True, default='subdir', choices=USE_DIRECTION_CHOICES, max_length=10)
            'has_aeroexpress',  # has_aeroexpress = models.BooleanField(_(u'по станции ходят аэроэкспрессы'), blank=True, null=False, default=False)
            'near_metro',  # near_metro = models.CharField(verbose_name=_(u'рядом с метро'), default=None, blank=True, null=True, max_length=25)
            # 'last_change',  # last_change = models.DateTimeField(verbose_name=_(u'дата последней проверки'), default=None, blank=True, null=True, help_text=_(u"выставляется при ручной проверке адреса, названий и тд."))  # noqa

            # RASP-3855
            'photo',  # photo = models.ImageField(verbose_name=_(u'фото станции'), upload_to='data/station/photo', null=True, blank=True, default=None)
            'schema_image',  # schema_image = models.ImageField(verbose_name=_(u'Схема станции'), upload_to='data/station/schema_image', null=True, blank=True, default=None)
            'panorama_url',  # panorama_url = models.URLField(verbose_name=_(u"ссылка на панораму"), null=True, blank=True)

            # RASP-4135
            'show_settlement',  # show_settlement = models.BooleanField(verbose_name=_(u"показывать город в адресе"), default=True, help_text=_(u"писать ли перед адресом название города станции"))
            'tablo_state',  # tablo_state = models.CharField(choices=TABLO_STATE_CHOICES, default="", verbose_name=_(u"табло"), max_length=10, blank=True)
            'tablo_state_prev',  # tablo_state_prev = models.CharField(choices=TABLO_STATE_CHOICES, default="", verbose_name=_(u"табло (предыдущее значение)"), max_length=10, blank=True)

            # TODO Как с этим быть?
            # 'synonyms',  # synonyms = generic.GenericRelation('PointSynonym')

            'fuzzy_only',  # fuzzy_only = models.BooleanField(_(u"только нечеткие rtstations"), default=False)
            'virtual_end',  # virtual_end = models.BooleanField(_(u"виртуальная конечная"), default=False)
            'incomplete_bus_schedule',  # incomplete_bus_schedule = models.BooleanField(verbose_name=_(u'неполное расписание автобусов'), default=False)

            'show_mode',  # show_mode = models.CharField(verbose_name=_(u"режим отображения автобусов"), blank=False, default='block', choices=SHOW_MODE_CHOICES, max_length=5)

            # 'meta_title',  # meta_title = models.CharField(max_length=255, verbose_name=_(u'meta title'), null=True, blank=True)
            # 'meta_description',  # meta_description = models.TextField(verbose_name=_(u'meta description'), null=True, blank=True)

            # fuzzy sign group
            'is_fuzzy',  # is_fuzzy = models.BooleanField(_(u'нечеткое время отправления/прибытия'), default=False)
            'is_searchable_to',  # is_searchable_to = models.BooleanField(_(u'искать до станции'), default=True)
            'is_searchable_from',  # is_searchable_from = models.BooleanField(_(u'искать от станции'), default=True)
            'in_station_schedule',  # in_station_schedule = models.BooleanField(_(u'в расписании по станции'), default=True)
            'in_thread',  # in_thread = models.BooleanField(_(u'показывать на странице нитки'), default=True)

            'show_tablo_stat',  # show_tablo_stat = models.BooleanField(_(u"показывать отмены и задержки по станции на главной странице Расписаний"), default=True)
            # 'modified_at',  # modified_at = models.DateTimeField(_(u'Дата-время изменения'), auto_now=True, null=False, blank=True)
        ],
    },
    {
        'model': CodeSystem,
        'fields': [
            'code',
            'title',
        ],
    },
    {
        # TODO Оптимизировать как—то. Очень долго выполняется, порядка минуты.
        # 156000 записей.
        'model': StationCode,
        'fields': [
            'code',
            FK('station', Station),
            FK('system', CodeSystem),
        ],
    },
    {
        'model': Region,
        'fields': [
            L_field('title', add_local_field=True, extra={
                'ru': ['nominative'],
                'en': ['nominative'],
                'uk': ['nominative'],
                'tr': ['nominative'],
            }),

            FK('country', Country),

            '_geo_id',
            'agent_geo_id',
            'time_zone',
            'hidden',
            'disputed_territory',
            '_kladr_id',
            'koatuu',

            L_field('new_L_title', add_local_field=True, extra={
                'ru': ['nominative'],
                'en': ['nominative'],
                'uk': ['nominative'],
                'tr': ['nominative'],
            }),
        ],
    },
    {
        'model': Currency,
        'fields': [
            'name',
            'code',
            'iso_code',

            'name_in',
            'name_uk',
            'name_uk_in',
            'template',
            'template_whole',
            'template_cents',
            'name_tr',
            'template_tr',
            'template_whole_tr',
            'template_cents_tr',

            'order',
            'order_tr',
            'order_ua',
        ],
    },
    {
        'model': AviaAlliance,
        'fields': [
            'logo_svg',
            'enabled',
            'title',
            'title_ru',
            'title_en',
            'title_tr',
            'title_uk',
            'description',
            'description_ru',
            'description_en',
            'description_tr',
            'description_uk',
            L_field('new_L_title', add_local_field=True, extra={
                'ru': ['nominative'],
                'en': ['nominative'],
                'uk': ['nominative'],
                'tr': ['nominative'],
            }),
            L_field('new_L_description', add_local_field=True),
        ]
    },
    {
        'model': PointSynonym,
        'fields': [
            'title',
            'content_type_id',
            'object_id',
            'search_type',
        ]
    }
]


def flatten_lists(items):
    def _flatten(ds):
        for d in ds:
            if isinstance(d, list):
                for j in _flatten(d):
                    yield j
            else:
                yield d
    return list(_flatten(items))


for m in IMPORT_MODELS:
    m['fields'] = flatten_lists(m['fields'])


def model_path(m):
    return m._meta.app_label + '/' + m.__name__


def field_name(k):
    if isinstance(k, FK):
        return k.field
    if isinstance(k, FILE):
        return k.field
    assert isinstance(k, basestring)
    return k


def field_attname(k):
    if isinstance(k, FK):
        return k.field + '_id'
    if isinstance(k, FILE):
        return k.field
    assert isinstance(k, basestring)
    return k


def pk_field(meta):
    return meta.get('pk_field', 'id')


def strip_mediaroot(text):
    return re.sub(ur'^.*?/media/data/', 'data/', text)


def eval_field_value(field, val):
    if isinstance(field, FILE):
        return val and strip_mediaroot(val)
    return val
