# -*- coding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
from optparse import OptionParser

from travel.avia.library.python.avia_data.models.review import FlightReview
from travel.avia.admin.lib.text import check_dirty_lang
from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log

log = logging.getLogger(__name__)
create_current_file_run_log()


def main():
    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    optparser.add_option('-i', '--id',  type="int", help='review id')

    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    log.info('*** Start')

    if options.id:
        reviews = FlightReview.objects.filter(id=options.id)
    else:
        reviews = FlightReview.objects.all()

    if not len(reviews):
        log.info("No data")

    for r in reviews:
        try:
            dirty_lang_class = check_dirty_lang(r.review_content)

        except Exception:
            log.exception("ERROR")
            continue

        except:
            log.error('Error while dirty lang check')
            continue

        if options.id:
            log.info('%s %s: %s' % (r.id, dirty_lang_class, r.review_content))

        elif dirty_lang_class:
            log.info('%s %s: %s' % (r.id, dirty_lang_class, r.review_content))

        r.dirty_lang_class = dirty_lang_class
        r.save()

    log.info('*** Done')
