# -*- encoding: utf-8 -*-
import sys
from datetime import datetime, timedelta
from optparse import OptionParser

import yt.logger_config as yt_logger_config
import yt.logger as yt_logger

ALLOWED_ENVS = ['production', 'dev']


def main():
    import travel.avia.admin.init_project  # noqa

    import logging

    from django.conf import settings

    from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
    from travel.avia.admin.lib.tablo_compressor import tablo_compressor_factory

    log = logging.getLogger(__name__)
    create_current_file_run_log()

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    optparser.add_option('-d', '--deep', action='store', type="int", default=2)
    optparser.add_option('-s', '--now', action='store', type="string")
    optparser.add_option('-f', '--force', action='store_true')
    optparser.add_option("-p", "--proxy", dest="proxy", default=settings.YT_PROXY)

    options, args = optparser.parse_args()
    now = datetime.now().date()
    if options.now:
        now = datetime.strptime(options.now, '%Y-%m-%d').date()

    if options.verbose:
        add_stdout_handler(log)
    else:
        yt_logger_config.LOG_LEVEL = 'WARNING'
        reload(yt_logger)

    log.info('Start')

    current_env = settings.ENVIRONMENT
    if current_env not in ALLOWED_ENVS:
        allowed_envs_str = ', '.join(ALLOWED_ENVS)
        log.info('Current ENVIRONMENT: %s. Only %s allowed.' % (current_env, allowed_envs_str))
        log.info('Exit')
        sys.exit()

    tablo_compressor = tablo_compressor_factory.create(proxy=options.proxy)

    has_error = False
    for i in range(options.deep, -1, -1):
        import_date = now - timedelta(days=i)

        log.info('Start compress tablo for %s', import_date)
        status, message = tablo_compressor.create_compressed_tablo(import_date, force=options.force)
        log.info('End compress tablo for %s with status [%s] and message [%s]', import_date, status, message)

        if status == 'error':
            has_error = True

    if has_error:
        log.error('End')
        sys.exit(1)
    else:
        log.info('End')
