# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from datetime import datetime, time, timedelta

import pytz

from travel.avia.library.python.common.utils.date import MSK_TZ

COLLECT_BOOKING_DATA_YQL_TEMPLATE = """
use hahn;
SELECT
    label
FROM `{cpa_order_path}`
WHERE
    status = 'confirmed'
    AND (
        {partners_where_clause}
    )
"""

START_EPOCH = pytz.UTC.localize(datetime(1970, 1, 1))


def _to_utc_timestamp(msk_day):
    naive_msk_dt = datetime.combine(msk_day, time.min)
    return int((MSK_TZ.localize(naive_msk_dt) - START_EPOCH).total_seconds())


def _create_partners_where_clause(interval_by_billing_order_id):
    single_partner_template = """
    (
        billing_order_id = {billing_order_id}
        AND created_at >= {start}
        AND created_at < {end}
    )
    """
    parts = []
    for billing_order_id, interval in interval_by_billing_order_id.items():
        parts.append(single_partner_template.format(
            billing_order_id=billing_order_id,
            start=_to_utc_timestamp(interval.start),
            end=_to_utc_timestamp(interval.end + timedelta(days=1)),  # продажи могут быть на следующий день
        ))
    return ' OR '.join(parts)


def build_booking_data_yql(cpa_order_path, interval_by_billing_order_id):
    return COLLECT_BOOKING_DATA_YQL_TEMPLATE.format(
        cpa_order_path=cpa_order_path,
        partners_where_clause=_create_partners_where_clause(interval_by_billing_order_id),
    )
