import operator
from collections import namedtuple


class DateInterval(namedtuple('DateInterval', 'start, end')):
    def has(self, day, include_end=False):
        if include_end:
            return self.start <= day <= self.end
        else:
            return self.start <= day < self.end

    def __contains__(self, day):
        return self.has(day)


def join_intervals(intervals):
    if not intervals:
        return intervals

    result = []
    intervals = sorted(intervals, key=operator.attrgetter('start'))
    current_interval = intervals[0]
    for interval in intervals[1:]:
        if interval.start <= current_interval.end:
            if interval.end > current_interval.end:
                current_interval = DateInterval(current_interval.start, interval.end)
        else:
            result.append(current_interval)
            current_interval = interval
    result.append(current_interval)
    return result
