# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

from datetime import datetime
from optparse import OptionParser

from travel.avia.admin.lib.yt_helpers import AviaYtClientFabric


def main():
    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    optparser.add_option('-s', '--source', dest='source', help='Redirect log source folder')
    optparser.add_option('-d', '--destination', dest='destination', help='Destination folder')
    optparser.add_option('-f', '--from-date', dest='from_date', help='From date (YYYY-MM-DD)')
    optparser.add_option('-t', '--to-date', dest='to_date', help='To date (YYYY-MM-DD)')
    optparser.add_option('--force', action='store_true')

    options, args = optparser.parse_args()

    if not options.source:
        optparser.print_help()
        optparser.error('Source required')

    if not options.destination:
        optparser.print_help()
        optparser.error('Destination required')

    if not options.from_date:
        optparser.print_help()
        optparser.error('From date required')
    from_date = datetime.strptime(options.from_date, '%Y-%m-%d').date()

    if not options.to_date:
        optparser.print_help()
        optparser.error('To date required')
    to_date = datetime.strptime(options.to_date, '%Y-%m-%d').date()

    ytc = AviaYtClientFabric().create()

    for table in ytc.tables_for_daterange(options.source, from_date, to_date):
        destination_table = '{}/{}'.format(options.destination, table.split('/')[-1])
        print 'Copy {} to {}'.format(table, destination_table)

        ytc.copy(
            source_path=table,
            destination_path=destination_table,
            force=options.force,
        )
