# -*- coding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
from optparse import OptionParser
from urllib import urlencode

from django.conf import settings
from django.utils.html import escape
from jinja2 import Template

from travel.avia.library.python.common.lib.mail import SmailikClient
from travel.avia.library.python.common.models.schedule import Company
from travel.avia.library.python.common.models.transport import TransportType
from travel.avia.library.python.common.utils.tanker import Tanker

from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout

log = logging.getLogger(__name__)
ALLOWED_ENVS = ['production', 'dev']
EMAIL = 'avia-process@yandex-team.ru'
TEMPLATE = Template(u"""
{%- for company in companies %}
<p>{{company.id}} {{company.title_ru}} {{company.seo_description_i18n}}</p>
{%- endfor %}
""")


def send_email(companies):
    smailik = SmailikClient(
        service='Flights.Yandex',
        send_from=u'Яндекс.Авиабилеты &lt;noreply@admin.avia.yandex-team.ru&gt;',
        smailik_dir='/var/spool/smailik-preparer/avia-scripts/'
    )
    log.info('New tanker fields for %d companies %r', len(companies), companies)

    smailik.send_email(
        EMAIL,
        escape(u'Добавлено %d новых ключей в танкере для авиакомпаний' % len(companies)),
        TEMPLATE.render(companies=companies)
    )


def _main():
    current_env = settings.ENVIRONMENT
    if current_env not in ALLOWED_ENVS:
        allowed_envs_str = ', '.join(ALLOWED_ENVS)
        log.info('Current ENVIRONMENT %s. Run only %s allowed.', current_env, allowed_envs_str)
        return

    companies = Company.objects.filter(t_type_id=TransportType.PLANE_ID)
    new_tanker_fields = []
    keys = {}
    args = {
        'project': 'ticket',
        'keyset': 'company_seo_description',
        'branch': 'master',
    }
    tanker = Tanker(
        project=args['project'], tanker='stable', mode='onlyadd', branch=args['branch']
    )

    for company in companies:
        key = '{id}_{slug}'.format(id=company.id, slug=company.slug)
        keys[key] = {
            "info": {
                "context": "",
                "is_plural": False,
                "references": ""
            },
        }
        tanker_key_url = 'https://tanker.yandex-team.ru/?{}'.format(urlencode(dict(args, key=key)))
        if company.seo_description_i18n != tanker_key_url:
            company.seo_description_i18n = tanker_key_url
            new_tanker_fields.append(company)
    if new_tanker_fields:
        send_email(new_tanker_fields)

    if tanker.upload(args['keyset'], keys=keys, languages=[]):
        for company in new_tanker_fields:
            company.save(update_fields=['seo_description_i18n'])


def main():
    create_current_file_run_log()
    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()
    if options.verbose:
        print_log_to_stdout()
    log.info('Start')
    _main()
    log.info('Done')
