# -*- coding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
from optparse import OptionParser

from django.conf import settings
from django.utils.html import escape
from jinja2 import Template

from travel.avia.library.python.common.lib.mail import SmailikClient
from travel.avia.library.python.common.models.holidays import Holiday
from travel.avia.library.python.common.utils.tanker import Tanker

from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout

log = logging.getLogger(__name__)
ALLOWED_ENVS = ['production', 'dev']
EMAIL = 'avia-process@yandex-team.ru'
TEMPLATE = Template(u"""
{%- for holiday in holidays %}
<p>{{holiday.id}} {{holiday.title_ru}} {{holiday.name_tanker_key}}</p>
{%- endfor %}
""")


def send_email(holidays):
    smailik = SmailikClient(
        service='Flights.Yandex',
        send_from=escape(u'Яндекс.Авиабилеты <noreply@admin.avia.yandex-team.ru>'),
        smailik_dir='/var/spool/smailik-preparer/avia-scripts/'
    )
    log.info('New tanker fields for %d holidays %r', len(holidays), holidays)

    smailik.send_email(
        EMAIL,
        escape(u'Добавлено %d новых ключей в танкере для праздников' % len(holidays)),
        TEMPLATE.render(holidays=holidays)
    )


def _main():
    current_env = settings.ENVIRONMENT
    if current_env not in ALLOWED_ENVS:
        allowed_envs_str = ', '.join(ALLOWED_ENVS)
        log.info('Current ENVIRONMENT %s. Allowed envs are %s.', current_env, allowed_envs_str)
        return

    tanker = Tanker(
        project='ticket', tanker='stable', mode='onlyadd', branch='master'
    )

    affected_holiday_objects = []
    keys = {}
    for holiday in Holiday.objects.all():
        key = 'holiday_{id}'.format(id=holiday.id)
        keys[key] = {
            'info': {
                'context': holiday.title,
                'is_plural': False,
                'references': ''
            }
        }
        if holiday.name_tanker_key != key:
            holiday.name_tanker_key = key
            affected_holiday_objects.append(holiday)

    if tanker.upload('holiday-names', keys=keys):
        for holiday in affected_holiday_objects:
            holiday.save(update_fields=['name_tanker_key'])
        if affected_holiday_objects:
            send_email(affected_holiday_objects)


def main():
    create_current_file_run_log()
    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()
    if options.verbose:
        print_log_to_stdout()
    log.info('Start')
    _main()
    log.info('Done')
