# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging

from travel.avia.admin.feature_flag_app.models import FeatureFlag, Service, ServiceFeatureFlagRelation
from travel.avia.admin.lib.logs import add_stdout_handler
from travel.avia.admin.lib.feature_flags import new_pricing_flag_name_by_partner_code, extended_report_flag_name_by_partner_code


logger = logging.getLogger(__name__)


PARTNER_CODE_LIST = [
    'tinkoff',
    'megotravel',
    'ozon',
    'kiwi',
    'citytravel',
    'onetwotrip',
    'superkassa',
    'trip_ru',
    'ticketsru',
    'aviakass',
    'kupibilet',
    'biletix',
    'tripcom',
    'svyaznoy',
    'biletdv',
    'agent',
    'ufs',
    'moireis',
    's7',
    'utair',
    'uzairways',
    'rulsine',
    'clickavia',
    'aviaoperator',
    'biletinet',
    'gogate',
    'teztour',
    'chabooka',
    'chartex',
    'charterok',
    'csa',
    'charterbilet',
    'deltatours',
    'biletikaeroag',
    'expressavia',
]


def create_price_flag(partner_code, ticket_daemon_api):
    price_flag = new_pricing_flag_name_by_partner_code(partner_code)
    flag, created = FeatureFlag.objects.get_or_create(
        code=price_flag,
        defaults={
            'startrack_id': 'RASPTICKETS-14959',
            'description': u'Новое ценообразование для партнера {}'.format(partner_code),
            'enabled': False,
        },
    )

    if created:
        logger.info('Create price flag for %s', partner_code)

    else:
        logger.info('Found existing flag for %s', partner_code)

    _, created = ServiceFeatureFlagRelation.objects.get_or_create(
        service=ticket_daemon_api,
        feature_flag=flag,
    )

    if created:
        logger.info('Create relatoin between ticket-daemon-api and feature flag')
    else:
        logger.info('Found existing relatoin between ticket-daemon-api and feature flag')


def create_extended_report_flag(partner_code, admin):
    report_flag = extended_report_flag_name_by_partner_code(partner_code)
    flag, created = FeatureFlag.objects.get_or_create(
        code=report_flag,
        defaults={
            'startrack_id': 'RASPTICKETS-14959',
            'description': u'Расширенный отчет для партнера {}'.format(partner_code),
            'enabled': False,
        },
    )

    if created:
        logger.info('Create extedned report flag for %s', partner_code)

    else:
        logger.info('Found existing flag for %s', partner_code)

    _, created = ServiceFeatureFlagRelation.objects.get_or_create(
        service=admin,
        feature_flag=flag,
    )

    if created:
        logger.info('Create relatoin between admin and feature flag')
    else:
        logger.info('Found existing relatoin between admin and feature flag')


def _main():
    logger.info('Start')
    admin = Service.objects.get(code='admin')
    ticket_daemon_api = Service.objects.get(code='ticket-daemon-api')

    for partner_code in PARTNER_CODE_LIST:
        logger.info('Partner: %s', partner_code)
        create_price_flag(partner_code, ticket_daemon_api)
        create_extended_report_flag(partner_code, admin)

    logger.info('End')


def main():
    add_stdout_handler(logger)
    _main()
