USE hahn;
DECLARE $query_date AS String;
DECLARE $partner_code AS String;
DECLARE $billing_order_id as Int;
DECLARE $conversion as Float;

$redirects=(
    SELECT
        fielddate,
        source,
        COUNT(*) as redirects
    FROM (
        SELECT
            substring(ISO_EVENTTIME,0,10) as fielddate,
            (CASE
                WHEN UTM_SOURCE = 'rasp' AND UTM_MEDIUM = 'redirect' THEN 'direct_rasp'
                WHEN UTM_SOURCE = 'sovetnik' AND UTM_CONTENT = 'redirect' THEN 'direct_sovetnik'
                WHEN (UTM_SOURCE = 'wizard_ru' OR UTM_SOURCE = 'unisearch_ru') AND WIZARDREDIRKEY IS NOT NULL THEN 'direct_wizard'
                WHEN (UTM_SOURCE = 'wizard_ru' OR UTM_SOURCE = 'unisearch_ru') AND WIZARDREDIRKEY IS NULL THEN 'indirect_wizard'
                ELSE 'indirect'
            END) as source
        FROM RANGE (`home/avia/logs/avia-redir-balance-by-day-log`, $query_date, $query_date)
        WHERE
            FILTER=0
            AND BILLING_ORDER_ID=$billing_order_id
            AND NATIONAL_VERSION='ru'
    )
    GROUP BY fielddate, source
);

$sales=(
    SELECT
        fielddate,
        source,
        COUNT(*) as sales
    FROM (
        SELECT
            substring(r.ISO_EVENTTIME,0,10) as fielddate,
            (CASE
                WHEN r.UTM_SOURCE = 'rasp' AND r.UTM_MEDIUM = 'redirect' THEN 'direct_rasp'
                WHEN r.UTM_SOURCE = 'sovetnik' AND r.UTM_CONTENT = 'redirect' THEN 'direct_sovetnik'
                WHEN (r.UTM_SOURCE = 'wizard_ru' OR r.UTM_SOURCE = 'unisearch_ru') AND r.WIZARDREDIRKEY IS NOT NULL THEN 'direct_wizard'
                WHEN (r.UTM_SOURCE = 'wizard_ru' OR r.UTM_SOURCE = 'unisearch_ru') AND r.WIZARDREDIRKEY IS NULL THEN 'indirect_wizard'
                ELSE 'indirect'
            END) as source
        FROM RANGE (`home/avia/logs/avia-redir-balance-by-day-log`, $query_date, $query_date) as r
        JOIN `home/travel/prod/cpa/avia/orders` as s
        ON r.MARKER=s.label
        WHERE
            r.FILTER=0
            AND r.NATIONAL_VERSION='ru'
            AND s.partner_name=$partner_code
            AND s.status='confirmed'
    )
    GROUP BY fielddate, source
);

SELECT r.fielddate, s.source, s.sales, r.redirects, s.sales * $conversion * 100 / r.redirects as cpc
FROM
    $redirects as r
    JOIN $sales as s
    USING (fielddate, source)
