DROP PROCEDURE IF EXISTS count_broken_rows_referring_to_www_station;

DELIMITER $$

CREATE PROCEDURE count_broken_rows_referring_to_www_station()
BEGIN
    DECLARE referrer_table char(64) DEFAULT NULL;
    DECLARE referrer_table_fk char(64) DEFAULT NULL;
    DECLARE referrer_table_constraint char(64) DEFAULT NULL;
    DECLARE done TINYINT DEFAULT FALSE;
    DECLARE is_nullable TINYINT DEFAULT FALSE;
    DECLARE referrer_table_fetcher
        CURSOR FOR
        select table_name, column_name, is_nullable  from information_schema.columns  where
        column_name regexp '^(.+_)?station(_from|_to)?_idx?$'
            and table_schema = DATABASE()
        and table_name not in
          (     select table_name
          FROM information_schema.KEY_COLUMN_USAGE
          WHERE          REFERENCED_TABLE_NAME = "www_station"
          AND REFERENCED_COLUMN_NAME = "id"
          AND CONSTRAINT_SCHEMA = DATABASE() );
    # catch exception when cursour runs out of rows
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
    OPEN referrer_table_fetcher;
    offset_loop:
    LOOP
        FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, is_nullable;
        IF done THEN
            LEAVE offset_loop;
        ELSE
            SET @query = CONCAT(' SELECT ', char(39), referrer_table, char(39), ' as referrer_table, ',
                                char(39), referrer_table_fk, char(39), ' as referrer_table_fk, ',
                                ' count(*) as total_row, sum(CASE WHEN ', referrer_table_fk,
                                ' IS NOT NULL AND ',
                                referrer_table_fk,
                                ' NOT IN (SELECT id from www_station) THEN 1 ELSE 0 END) as broken_rows FROM ',
                                 referrer_table);
            PREPARE statement FROM @query;
            EXECUTE statement;
            DEALLOCATE PREPARE statement;
        END IF;
    END LOOP;
END $$

DELIMITER ;
