USE hahn;

DECLARE $NDirections AS Int64;
DECLARE $StartDate AS String;
DECLARE $EndDate AS String;
DECLARE $StartRedirectDate AS String;
DECLARE $EndRedirectDate AS String;
DECLARE $OutputTable AS String;
DECLARE $MinNumberOfRedirects AS Int64;

$wizardQueryRoot = 'home/logfeller/logs/avia-wizard-query-log/1d';
$wizardResponseRoot = 'home/logfeller/logs/avia-wizard-response-log/1d';
$wizardPointParseRoot = 'home/logfeller/logs/avia-wizard-point-parse-log/1d';
$wizardShowRoot = 'home/logfeller/logs/avia-wizard-show-log/1d';
$RedirBalanceRoot = 'home/avia/logs/avia-redir-balance-by-day-log';

$queries = (
    SELECT job_id
    FROM RANGE($wizardQueryRoot, $StartDate, $EndDate)
    WHERE
        (dev IS NULL OR dev == 0) AND
        organic != True AND
        main_reqid = reqid AND
        NOT DictContains(Yson::ConvertToDict(DictLookup(_rest, 'raw_args')), 'departure_date') -- queries without dates
);

$ok_responses = (
    SELECT
        job_id
    FROM RANGE($wizardResponseRoot, $StartDate, $EndDate)
    WHERE status = 'OK'
);
$pp_parsed = (
    SELECT
        job_id,
        from_point_key,
        to_point_key
    FROM RANGE($wizardPointParseRoot, $StartDate, $EndDate)
    WHERE from_point_key != '' AND to_point_key != ''
);
$shows = (
    SELECT DISTINCT(job_id)
    FROM RANGE($wizardShowRoot, $StartDate, $EndDate)
    WHERE index == 0
);

$ok_shows = (
    SELECT
        r.job_id as job_id
    FROM $ok_responses AS r
    LEFT ONLY JOIN $shows AS s
    USING (job_id)
);

$queries = (
    SELECT
        pp.from_point_key as from_id,
        pp.to_point_key as to_id
    FROM $queries as q
    LEFT SEMI JOIN $ok_shows AS o
    on q.job_id == o.job_id
    INNER JOIN $pp_parsed as pp
    on q.job_id == pp.job_id

);

$redir_stat = (
    SELECT
        FROMID AS from_id,
        TOID AS to_id,
        NATIONAL AS national_version,
        COUNT(*) AS cnt
    FROM RANGE(
        $RedirBalanceRoot,
        $StartRedirectDate,
        $EndRedirectDate
    )
    WHERE FILTER = 0
    GROUP BY FROMID, TOID, NATIONAL
    HAVING COUNT(*) > $MinNumberOfRedirects
);

INSERT INTO
    $OutputTable
WITH TRUNCATE

SELECT
    s.national_version AS national_version,
    q.from_id AS from_id,
    q.to_id AS to_id,
    count(*) AS cnt
FROM $queries AS q
INNER JOIN $redir_stat AS s
USING (from_id, to_id)
GROUP BY s.national_version, q.from_id, q.to_id
ORDER BY national_version, cnt DESC
LIMIT $NDirections;
