PRAGMA yt.InferSchema = "1000";
USE hahn;

-- $date = "2018-03-25";
-- $price_path = "home/logfeller/logs/rasp-tariffs-log/1d/" || $date;
-- $avia_searches_path = "home/logfeller/logs/avia-users-search-log/1d/" || $date;
-- $rasp_searches_path = "home/logfeller/logs/rasp-users-search-log/1d/" || $date;
-- $wizard_searches_path = "home/logfeller/logs/avia-wizard-query-log/1d/" || $date;

$format = DateTime::Format("%Y-%m-%d");
$get_date_from_unixtime = ($unixtime) -> {
    RETURN $format(DateTime::FromSeconds(CAST($unixtime AS Uint32)))
};

$construct_geo_id = ($object_type, $object_id) -> {
    $prefix = IF(
        String::StartsWith($object_type, "Settlement"),
        "c",
        "s"
    );
    RETURN $prefix || $object_id;
};


$heater_query = (
SELECT
    from_id,
    to_id,
    adults,
    date_forward,
    date_backward,
    children,
    infants
FROM $price_path
WHERE type = "plane" AND String::StartsWith(String::SplitToList(qid, ".")[1], "yeah")
GROUP BY
    $construct_geo_id(object_from_type, object_from_id) AS from_id,
    $construct_geo_id(object_to_type, object_to_id) AS to_id,
    CAST(adults AS Int64) AS adults,
    CAST(children AS Int64) ?? 0 AS children,
    CAST(infants AS Int64) ?? 0 AS infants,
    date_forward,
    date_backward
);

$avia_searches = (
SELECT
    from_id,
    to_id,
    adults,
    children,
    infants,
    date_forward,
    date_backward,
    COUNT(*) AS avia_searches_count
FROM $avia_searches_path AS avia_searches
LEFT SEMI JOIN $heater_query AS heater_queries2
ON
    avia_searches.fromId = heater_queries2.from_id AND
    avia_searches.toId = heater_queries2.to_id AND
    avia_searches.adult_seats = heater_queries2.adults AND
    avia_searches.children_seats = heater_queries2.children AND
    avia_searches.infant_seats = heater_queries2.infants AND
    avia_searches.when = heater_queries2.date_forward AND
    avia_searches.return_date = heater_queries2.date_backward
WHERE national_version = "ru"
GROUP BY
    fromId AS from_id,
    toId AS to_id,
    adult_seats AS adults,
    children_seats AS children,
    infant_seats AS infants,
    `when` AS date_forward,
    `return_date` AS date_backward
);

$rasp_searches = (
SELECT
    from_id,
    to_id,
    adults,
    children,
    infants,
    date_forward,
    date_backward,
    COUNT(*) AS rasp_searches_count
FROM $rasp_searches_path AS rasp_searches
LEFT SEMI JOIN $heater_query AS heater_queries2
ON
    rasp_searches.from_id = heater_queries2.from_id AND
    rasp_searches.to_id = heater_queries2.to_id AND
    CAST(rasp_searches.adults AS Int64) = heater_queries2.adults AND
    CAST(rasp_searches.children AS Int64) = heater_queries2.children AND
    CAST(rasp_searches.infants AS Int64) = heater_queries2.infants AND
    rasp_searches.when = heater_queries2.date_forward AND
    rasp_searches.return_date = heater_queries2.date_backward
WHERE national_version = "ru"
GROUP BY
    from_id AS from_id,
    to_id AS to_id,
    CAST(adults AS Int64) AS adults,
    CAST(children AS Int64) AS children,
    CAST(infants AS Int64) AS infants,
    `when` AS date_forward,
    `return_date` AS date_backward
);

$wizard_searches = (
SELECT
    from_id,
    to_id,
    date_forward,
    date_backward,
    1 AS adults,
    0 AS children,
    0 AS infants,
    COUNT(*) AS wizard_searches_count
FROM $wizard_searches_path AS wizard_searches
LEFT SEMI JOIN (
    SELECT
        from_id,
        to_id,
        date_forward,
        date_backward
    FROM $heater_query
    WHERE adults = 1 AND children = 0 AND infants = 0
    GROUP BY
        from_id,
        to_id,
        date_forward,
        date_backward
) AS heater_queries
ON
    wizard_searches.from_id = heater_queries.from_id AND
    wizard_searches.to_id = heater_queries.to_id AND
    wizard_searches.departure_date = heater_queries.date_forward AND
    wizard_searches.return_date = heater_queries.date_backward
GROUP BY
    wizard_searches.from_id AS from_id,
    wizard_searches.to_id AS to_id,
    wizard_searches.departure_date AS date_forward,
    wizard_searches.return_date AS date_backward
);

INSERT INTO
    $output_path
WITH TRUNCATE

SELECT
    $date AS fielddate,
    from_id,
    to_id,
    date_forward,
    date_backward,
    adults,
    infants,
    children,
    SUM(avia_searches.avia_searches_count ?? 0) AS avia_searches_count,
    SUM(rasp_searches.rasp_searches_count ?? 0) AS rasp_searches_count,
    SUM(wizard_searches.wizard_searches_count ?? 0) AS wizard_searches_count
FROM $avia_searches AS avia_searches
FULL JOIN $rasp_searches AS rasp_searches
ON (
    avia_searches.from_id = rasp_searches.from_id
    AND avia_searches.to_id = rasp_searches.to_id
    AND avia_searches.date_forward = rasp_searches.date_forward
    AND avia_searches.date_backward = rasp_searches.date_backward
)
FULL JOIN $wizard_searches AS wizard_searches
ON (
    wizard_searches.from_id = rasp_searches.from_id
    AND wizard_searches.to_id = rasp_searches.to_id
    AND wizard_searches.date_forward = rasp_searches.date_forward
    AND wizard_searches.date_backward = rasp_searches.date_backward
)
GROUP BY
    COALESCE(avia_searches.from_id, rasp_searches.from_id, wizard_searches.from_id) AS from_id,
    COALESCE(avia_searches.to_id, rasp_searches.to_id, wizard_searches.to_id) AS to_id,
    COALESCE(avia_searches.date_forward, rasp_searches.date_forward, wizard_searches.date_forward) AS date_forward,
    IF(
        COALESCE(avia_searches.date_backward, rasp_searches.date_backward, wizard_searches.date_backward) = '',
        '-',
        COALESCE(avia_searches.date_backward, rasp_searches.date_backward, wizard_searches.date_backward)
    ) AS date_backward,
    COALESCE(avia_searches.adults, rasp_searches.adults, wizard_searches.adults) AS adults,
    COALESCE(avia_searches.infants, rasp_searches.infants, wizard_searches.infants) AS infants,
    COALESCE(avia_searches.children, rasp_searches.children, wizard_searches.children) AS children;
